package tests;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.Arrays;

import org.junit.Test;

import model.BSTUtilities;

public class TestBST {
	@Test
	public void test_bst_in_order_traversal() {
		constructExampleTree();

		BSTUtilities<String> u = new BSTUtilities<>(); 
		ArrayList<BSTNode<String>> inOrderList = u.inOrderTraversal(n44); 
		assertTrue(inOrderList.size() == 16 + 17); /* 16 internal nodes + 17 external nodes */
		ArrayList<BSTNode<String>> expectedOrder = new ArrayList<>(Arrays.asList(
						extN1, n8, extN2, 
					n17, 
						extN10, n21, extN11, n28, extN12, n29, extN13, n32, extN3, 
				n44, 
						extN5, n54, extN6, n65, extN14, n68, extN15, n76, extN16, n80, extN17, n82, extN7, 
					n88, 
						extN8, n93, extN9, n97, extN4
		));
		assertEquals(expectedOrder, inOrderList);
	}

	@Test
	public void test_bst_right_rotation_1() {
		constructExampleTree();

		BSTUtilities<String> u = new BSTUtilities<>();
		u.rightRotate(n44, n17, n8);

		ArrayList<BSTNode<String>> inOrderList = u.inOrderTraversal(n17); 
		assertTrue(inOrderList.size() == 16 + 17); /* 16 internal nodes + 17 external nodes */
		ArrayList<BSTNode<String>> expectedOrder = new ArrayList<>(Arrays.asList(
				extN1, // T1 
				n8, // c
				extN2, // T2
				n17, // b
				extN10, n21, extN11, n28, extN12, n29, extN13, n32, extN3, // T3 
				n44, // a
				extN5, n54, extN6, n65, extN14, n68, extN15, n76, extN16, n80, extN17, n82, extN7, n88, extN8, n93, extN9, n97, extN4 // T4
		));
		assertEquals(expectedOrder, inOrderList);
	}
	
	@Test
	public void test_bst_right_rotation_2() {
		constructExampleTree();

		BSTUtilities<String> u = new BSTUtilities<>();
		u.rightRotate(n32, n28, n21);

		ArrayList<BSTNode<String>> inOrderList = u.inOrderTraversal(n44); 
		assertTrue(inOrderList.size() == 16 + 17); /* 16 internal nodes + 17 external nodes */
		ArrayList<BSTNode<String>> expectedOrder = new ArrayList<>(Arrays.asList(
				extN1, n8, extN2, n17, 
				extN10, // T1 
				n21, // c
				extN11, // T2 
				n28, // b
				extN12, n29, extN13, // T3 
				n32, // a
				extN3, // T4 
				n44, extN5, n54, extN6, n65, extN14, n68, extN15, n76, extN16, n80, extN17, n82, extN7, n88, extN8, n93, extN9, n97, extN4
		));
		assertEquals(expectedOrder, inOrderList);
	}
	
	@Test
	public void test_bst_right_rotation_3() {
		constructExampleTree();

		BSTUtilities<String> u = new BSTUtilities<>();
		u.rightRotate(n32, n28, n21);

		ArrayList<BSTNode<String>> inOrderList = u.inOrderTraversal(n44); 
		assertTrue(inOrderList.size() == 16 + 17); /* 16 internal nodes + 17 external nodes */
		ArrayList<BSTNode<String>> expectedOrder = new ArrayList<>(Arrays.asList(
				extN1, n8, extN2, n17, extN10, n21, extN11, n28, extN12, n29, extN13, n32, extN3, n44, 
				extN5, // T1
				n54, // c 
				extN6, // T2
				n65, // b 
				extN14, n68, extN15, n76, extN16, n80, extN17, n82, extN7, // T3 
				n88, // a
				extN8, n93, extN9, n97, extN4 // T4
		));
		assertEquals(expectedOrder, inOrderList);
	}

	/* Helper Method */
	// Reference: https://www.eecs.yorku.ca/~wangcw/teaching/lectures/2025/F/EECS3101/slides/03-Self-Balancing-Binary-Search-Trees.pdf#page=11
	private BSTNode<String> n44;
	private BSTNode<String> n17;
	private BSTNode<String> n88;
	private BSTNode<String> n8;
	private BSTNode<String> n32;
	private BSTNode<String> n65;
	private BSTNode<String> n97;
	private BSTNode<String> n28;
	private BSTNode<String> n54;
	private BSTNode<String> n82;
	private BSTNode<String> n93;
	private BSTNode<String> n21;
	private BSTNode<String> n29;
	private BSTNode<String> n76;
	private BSTNode<String> n68;
	private BSTNode<String> n80; 

	private BSTNode<String> extN1;
	private BSTNode<String> extN2;
	private BSTNode<String> extN3;
	private BSTNode<String> extN4;
	private BSTNode<String> extN5;
	private BSTNode<String> extN6;
	private BSTNode<String> extN7;
	private BSTNode<String> extN8;
	private BSTNode<String> extN9;
	private BSTNode<String> extN10;
	private BSTNode<String> extN11;
	private BSTNode<String> extN12;
	private BSTNode<String> extN13;
	private BSTNode<String> extN14;
	private BSTNode<String> extN15;
	private BSTNode<String> extN16;
	private BSTNode<String> extN17; 

	private void constructExampleTree() {
		n44 = new BSTNode<>(44, "44");
		n17 = new BSTNode<>(17, "17");
		n88 = new BSTNode<>(88, "88");
		n8 = new BSTNode<>(8, "8");
		n32 = new BSTNode<>(32, "32");
		n65 = new BSTNode<>(65, "65");
		n97 = new BSTNode<>(97, "97");
		n28 = new BSTNode<>(28, "28");
		n54 = new BSTNode<>(54, "54");
		n82 = new BSTNode<>(82, "82");
		n93 = new BSTNode<>(93, "93");
		n21 = new BSTNode<>(21, "21");
		n29 = new BSTNode<>(29, "29");
		n76 = new BSTNode<>(76, "76");
		n68 = new BSTNode<>(68, "68");
		n80 = new BSTNode<>(80, "80"); 

		extN1 = new BSTNode<>();
		extN2 = new BSTNode<>();
		extN3 = new BSTNode<>();
		extN4 = new BSTNode<>();
		extN5 = new BSTNode<>();
		extN6 = new BSTNode<>();
		extN7 = new BSTNode<>();
		extN8 = new BSTNode<>();
		extN9 = new BSTNode<>();
		extN10 = new BSTNode<>();
		extN11 = new BSTNode<>();
		extN12 = new BSTNode<>();
		extN13 = new BSTNode<>();
		extN14 = new BSTNode<>();
		extN15 = new BSTNode<>();
		extN16 = new BSTNode<>();
		extN17 = new BSTNode<>(); 

		n44.setLeft(n17); n44.setRight(n88);
		n17.setLeft(n8); n17.setRight(n32);
		n88.setLeft(n65); n88.setRight(n97);
		n8.setLeft(extN1); n8.setRight(extN2);
		n32.setLeft(n28); n32.setRight(extN3);
		n65.setLeft(n54); n65.setRight(n82);
		n97.setLeft(n93); n97.setRight(extN4);
		n28.setLeft(n21); n28.setRight(n29);
		n54.setLeft(extN5); n54.setRight(extN6);
		n82.setLeft(n76); n82.setRight(extN7);
		n93.setLeft(extN8); n93.setRight(extN9);
		n21.setLeft(extN10); n21.setRight(extN11);
		n29.setLeft(extN12); n29.setRight(extN13);
		n76.setLeft(n68); n76.setRight(n80);
		n68.setLeft(extN14); n68.setRight(extN15);
		n80.setLeft(extN16); n80.setRight(extN17);
	}
}
