package model;

import java.util.ArrayList;

import tests.BSTNode;

public class BSTUtilities<E> {

	public ArrayList<BSTNode<E>> inOrderTraversal(BSTNode<E> root) {
		ArrayList<BSTNode<E>> result = new ArrayList<>();
		if(root.isExternal()) {
			result.add(root);
		}
		else {
			result.addAll(inOrderTraversal(root.getLeft()));
			result.add(root);
			result.addAll(inOrderTraversal(root.getRight()));
		} 
		return result;
	}
	
	/*
	 * Perform a right rotation on the middle node b.
	 * Assumption: a (b's parent), b (c's parent), and c slant to the left.
	 */
	public void rightRotate(BSTNode<E> a, BSTNode<E> b, BSTNode<E> c) {
		/* Your Task
		 * Hint: https://www.eecs.yorku.ca/~wangcw/teaching/lectures/2025/F/EECS3101/slides/03-Self-Balancing-Binary-Search-Trees.pdf#page=26
		 */
		
		BSTNode<E> T1 = c.getLeft();
		BSTNode<E> T2 = c.getRight();
		BSTNode<E> T3 = b.getRight();
		BSTNode<E> T4 = a.getRight();
		
		if(a.getParent() != null) {
			BSTNode<E> newRoot = b;
			if(a.getParent().getLeft() == a) {
				a.getParent().setLeft(newRoot);
			}
			else {
				a.getParent().setRight(newRoot);
			}
		}
		
		b.setLeft(c); // not necessary
		b.setRight(a);
		c.setLeft(T1); // not necessary
		c.setRight(T2); // not necessary
		a.setLeft(T3);
		a.setRight(T4);
	}
}
