package junit_tests;

import static org.junit.Assert.*;

import org.junit.Test;

import model.*;

public class RecursiveMethodsTest {
	
	@Test
	public void testTriangle0() {
		RecursiveMethods rm = new RecursiveMethods();
		assertEquals(0, rm.triangle(0));
	}
	
	@Test
	public void testTriangle1() {
		RecursiveMethods rm = new RecursiveMethods();
		assertEquals(1, rm.triangle(1));
	}
	
	@Test
	public void testTriangle2() {
		RecursiveMethods rm = new RecursiveMethods();
		assertEquals(3, rm.triangle(2));
	}
	
	@Test
	public void testTriangle3() {
		RecursiveMethods rm = new RecursiveMethods();
		assertEquals(6, rm.triangle(3));
	}
	
	@Test
	public void testTriangle4() {
		RecursiveMethods rm = new RecursiveMethods();
		assertEquals(10, rm.triangle(4));
	}
	
	@Test
	public void testTriangle5() {
		RecursiveMethods rm = new RecursiveMethods();
		assertEquals(15, rm.triangle(5));
	}
	
	@Test
	public void testArray220a() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] nums = {1, 2, 20};
		assertEquals(true, rm.array220(nums, 0));
		assertEquals(true, rm.array220(nums, 0, nums.length - 1));
	}
	
	@Test
	public void testArray220b() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] nums = {3, 30};
		assertEquals(true, rm.array220(nums, 0));
		assertEquals(true, rm.array220(nums, 0, nums.length - 1));
	}
	
	@Test
	public void testArray220c() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] nums = {3};
		assertEquals(false, rm.array220(nums, 0));
		assertEquals(false, rm.array220(nums, 0, nums.length - 1));
	}
	
	@Test
	public void testArray220d() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] nums = {};
		assertEquals(false, rm.array220(nums, 0));
		assertEquals(false, rm.array220(nums, 0, nums.length - 1));
	}
	
	@Test
	public void testArray220e() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] nums = {5, 49, 19, 191, 3, 30, 4};
		assertEquals(true, rm.array220(nums, 0));
		assertEquals(true, rm.array220(nums, 0, nums.length - 1));
	}
	
	@Test
	public void testArray220f() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] nums = {50, 5, 190, 19, 30, 3};
		assertEquals(false, rm.array220(nums, 0));
		assertEquals(false, rm.array220(nums, 0, nums.length - 1));
	}
	
	@Test
	public void testArithmeticArray1() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] seq = rm.arithmeticArray(4, 3, 0);
		int[] expected = {};
		assertArrayEquals(expected, seq);
	}
	
	@Test
	public void testArithmeticArray2() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] seq = rm.arithmeticArray(4, 3, 1);
		int[] expected = {4};
		assertArrayEquals(expected, seq);
	}
	
	@Test
	public void testArithmeticArray3() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] seq = rm.arithmeticArray(4, 3, 5);
		int[] expected = {4, 7, 10, 13, 16};
		assertArrayEquals(expected, seq);
	}
	
	@Test
	public void testArithmeticArray4() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] seq = rm.arithmeticArray(4, 3, 10);
		int[] expected = {4, 7, 10, 13, 16, 19, 22, 25, 28, 31};
		assertArrayEquals(expected, seq);
	}
	
	@Test
	public void testArithmeticArray5() {
		RecursiveMethods rm = new RecursiveMethods();
		int[] seq = rm.arithmeticArray(4, -3, 10);
		int[] expected = {4, 1, -2, -5, -8, -11, -14, -17, -20, -23};
		assertArrayEquals(expected, seq);
	}
}
