package without_inheritance;

import static org.junit.Assert.*;

import org.junit.Test;

public class TestStudent {

	@Test
	public void test() {
		ResidentStudent jim = new ResidentStudent("Jim");
		Course cse114 = new Course("CSE114", 500.0);
		Course cse215 = new Course("CSE215", 500.0);
		
		jim.register(cse114);
		jim.register(cse215);
		
		jim.setPremiumRate(1.25);
		assertEquals(2 * 500 * 1.25, jim.getTuition(), 0.001);
		
		NonResidentStudent jeremy = new NonResidentStudent("Jeremy");
		
		jeremy.register(cse114);
		jeremy.register(cse215);
		
		jeremy.setDiscountRate(0.75);
		
		assertEquals(2 * 500 * 0.75, jeremy.getTuition(), 0.001);

		
		StudentManagementSystem sms = new StudentManagementSystem();
		sms.addResidentStudent(jim);
		sms.addNonResidentStudent(jeremy);
		
		Course rc = new Course("RC", 200.0);
		/* register all students (i.e., jim and jeremy)
		 * to RC. */
		sms.registerAll(rc);
		assertEquals((2 * 500 + 200) * 1.25, jim.getTuition(), 0.001);
		assertEquals((2 * 500 + 200) * 0.75, jeremy.getTuition(), 0.001);
	}

}
