note
	description: "Summary description for {WEATHER_DATA}."
	author: "Jackie Wang"
	date: "$Date$"
	revision: "$Revision$"

class
	WEATHER_DATA

create
	make

feature -- Event of changing data
	change_on_temperature: EVENT[TUPLE[REAL]]
		once
			create Result.make
		end

	change_on_humidity: EVENT[TUPLE[REAL]]
		once
			create Result.make
		end

	change_on_pressure: EVENT[TUPLE[REAL]]
		once
			create Result.make
		end

feature -- weather data available to observers

	temperature: REAL
	humidity: REAL
	pressure: REAL

	correct_limits(t,p,h: REAL): BOOLEAN
		do
			if -36 <= t and t <= 60
				and 50 <= p and p <= 110 -- kPa
				and 0.8 <= h and h <= 100 -- %R
			then
				Result := true
			end
		ensure
			-- temperature in centigrade
			Result implies -36 <=t and t <= 60
			-- pressure in kPA
			Result implies 50 <= p and p <= 110
			-- humidity in %RH
			Result implies 0.8 <= h and h <= 100
		end

feature -- Initialization
	make (t, p, h: REAL)
		do
			set_measurements (t, p, h)
		ensure then
			temperature = t
			pressure = p
			humidity = h
		end

feature  -- weather station interface
	set_measurements(t, p, h: REAL)
			-- called from weather station
		require
			correct_limits(t,p,h)
		do
			temperature := t
			pressure := p
			humidity := h
			change_on_temperature.publish ([t])
			change_on_humidity.publish ([p])
			change_on_pressure.publish ([h])
		ensure
			temperature = t
			pressure = p
			humidity = h
		end

invariant
	correct_limits(temperature, pressure, humidity)

end
