import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class CurrentConditions { 
	private double temperature;
	private double humidity;
	
	public void updateTemperature(double t) {
		temperature = t;
	}
	
	public void updateHumidity(double h) {
		humidity = h;
	}
	
	public CurrentConditions() {
		MethodHandles.Lookup lookup = MethodHandles.lookup();
		try {
			MethodHandle ut = lookup.findVirtual(
					this.getClass(),
					"updateTemperature",
					MethodType.methodType(void.class, double.class));
			MethodHandle uh = lookup.findVirtual(
					this.getClass(),
					"updateHumidity",
					MethodType.methodType(void.class, double.class));
			WeatherData.changeOnTemperature.subscribe(this, ut);
			WeatherData.changeOnHumidity.subscribe(this, uh);
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}
	
	public void display() {
		System.out.println("Temperature: " + temperature);
		System.out.println("Humidity: " + humidity);
	}
}
