note
	description: "Summary description for {STATISTICS}."
	author: "Jonathan S. Ostroff and Jackie Wang"
	date: "$Date$"
	revision: "$Revision$"

class
	STATISTICS
create
	make

feature -- Initialization
	make(wd: WEATHER_DATA)
		do
			min_temp := 15
			max_temp := 5
			wd.change_on_temperature.subscribe (agent update_temperature)
		end

feature -- Attributes
	current_temp: REAL
	max_temp: REAL
	min_temp: REAL
	sum_so_far: REAL
	num_readings: INTEGER

	update_temperature (t: REAL)
			-- Update temperature to 't'.
		do
			current_temp := t
			num_readings := num_readings + 1
      		sum_so_far := sum_so_far + current_temp
      		if current_temp > max_temp then
        		max_temp := current_temp
      		end
      		if  current_temp < min_temp then
        		min_temp := current_temp
      		end 
		end

	display
		do
			print("Avg/Max/Min temperature = ")
			print(sum_so_far / num_readings)
			print("/")
			print(max_temp)
			print("/")
			print(min_temp)
			print("%N")
		end

end
