note
	description: "Summary description for {EVENT}."
	author: ""
	date: "$Date$"
	revision: "$Revision$"


class EVENT [G -> TUPLE]

create
	make

feature -- Initialization
	actions: LIST [PROCEDURE [G]]

	make
		do
			create {LINKED_LIST [PROCEDURE [G]]} actions.make
		end

feature
	has(an_action: PROCEDURE [G]): BOOLEAN
		do
			Result :=  actions.has (an_action)
		end

	subscribe (an_action: PROCEDURE [G])
			-- Add an_action to the list to be notified.
		require
			an_action_not_void: an_action /= void
			an_action_not_already_attached: not has (an_action)
		do
			actions.extend (an_action)
		ensure
			an_action_attached: actions.count = old actions.count + 1 and actions.has (an_action)
		end

	publish (args: G)
			-- Notify (invoke) all actions in list attached to an event.

		do
			from
				actions.start
			until
				actions.after
			loop
				actions.item.call (args)
				actions.forth
			end
		end
end



