note
	description: "Summary description for {CURRENT_CONDITIONS}."
	author: "Jonathan S. Ostroff and Jackie Wang"
	date: "$Date$"
	revision: "$Revision$"

class
	CURRENT_CONDITIONS
create
	make

feature -- initialize
	make(wd: WEATHER_DATA)
		do
			wd.change_on_temperature.subscribe (agent update_temperature)
			wd.change_on_temperature.subscribe (agent update_humidity)
		end

feature
	temperature: REAL
	humidity: REAL

	update_temperature (t: REAL)
			-- Update temperature to 't'.
		do
			temperature := t
		end

	update_humidity (h: REAL)
			-- Update humidity to 'h'.
		do
			humidity := h
		end

	display
			-- display current conditions
		do
			io.put_string("Current Conditions: ")
			io.put_real (temperature)
			io.put_string (" degrees C and ")
			io.put_real (humidity)
			io.put_string (" percent humidity%N")
		end
end
