import java.lang.invoke.MethodHandle;
import java.util.Hashtable;

public class Event {
	Hashtable<Object, MethodHandle> listenersActions;
	
	Event() {
		listenersActions = new Hashtable<>();
	}
	
	void subscribe(Object listener, MethodHandle action) {
		listenersActions.put(listener, action);
	}
	
	void publish(Object arg) {
		for (Object listener : listenersActions.keySet()) {
			MethodHandle action = listenersActions.get(listener);
			try {
				action.invokeWithArguments(listener, arg);
			} catch (Throwable e) {
				 
			}
		}
	}
}