note
	description: "Summary description for {FORECAST}."
	author: "Jonathan S. Ostroff and Jackie Wang"
	date: "$Date$"
	revision: "$Revision$"

class
	FORECAST

create
	make

feature -- Initialization
	make(wd: WEATHER_DATA)
		do
			wd.change_on_pressure.subscribe (agent update_pressure)
		end

feature

	current_pressure: REAL
	last_pressure: REAL

	update_pressure (p: REAL)
			-- Update pressure to 'p'.
		do
			last_pressure := current_pressure
			current_pressure := p 
		end

	display
		do
			if current_pressure > last_pressure then
				print("Improving weather on the way!%N")
			elseif current_pressure = last_pressure then
					print("More of the same%N")
			elseif current_pressure < last_pressure then
					print("Watch out for cooler, rainy weather%N")
			end
		end
end
