indexing
   description: "Piece of electronic or computer equipment"
   note: ""
   status: ""
   date: "$Date: 1999/05/18 12:45:14 $"
   revision: "$Revision: 1.5 $"
   author: "Jean-Marc Jezequel"
deferred class EQUIPMENT
feature {ANY} -- Queries
   name : STRING
	 -- Name of this equipment
   power : REAL is deferred end
	 -- Electric power consumption
   net_price, discount_price : REAL is deferred end 
	 -- cost of this equipment
feature {ANY} -- Commands
   make (its_name : STRING) is
      -- Initialization
      require
	 its_name_not_void: its_name /= Void
      do
	 name := its_name
      end -- make
invariant
   name_not_void: name /= Void
   positive_power: power >= 0.0
   positive_price: discount_price >= 0.0
   real_discount: net_price >= discount_price
end -- EQUIPMENT

