indexing
   description: "Components having children and an optional parent"
   date: "$Date: 1999/05/18 12:45:14 $"
   revision: "$Revision: 1.5 $"
   author: "Jean-Marc Jezequel"
class COMPOSITE [T]
feature {ANY} -- Queries
--   parent : COMPOSITE [T] is do end
	 -- optional parent, default to Void. If an explicit reference
	 -- to the parent is needed, redefine as an attribute.
   has (child : T) : BOOLEAN is
	 -- does 'child' belong to the composite?
      require child_not_void: child /= Void
      do
	 Result := children.has(child) -- identity comparison
      end -- has
feature {ANY} -- Commands
   add (new_child : T) is
         -- add `new_child' to the composite
      require new_child_not_void: new_child /= Void
      do
         children.extend(new_child)
      ensure added: has(new_child)
      end -- add
   remove (child : T) is
         -- remove T from the composite
      require child_not_void: child /= Void
      do
      	children.search (child)
         children.remove
      ensure removed: not has(child)
      end -- remove
feature {NONE} -- Private
   children : LIST [T]
	 -- holding the parts.
invariant
   children_not_void: children /= Void
end -- COMPOSITE

