/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.visitor;

import com.university.bookstore.model.AudioBook;
import com.university.bookstore.model.EBook;
import com.university.bookstore.model.Magazine;
import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import com.university.bookstore.model.PrintedBook;
import com.university.bookstore.model.VideoMaterial;
import com.university.bookstore.visitor.MaterialVisitor;

public class ShippingCostCalculator
implements MaterialVisitor {
    private static final double PHYSICAL_ITEM_RATE = 0.5;
    private static final double MAGAZINE_FLAT_RATE = 2.0;
    private static final double DIGITAL_ITEM_RATE = 0.0;
    private double totalShippingCost = 0.0;

    @Override
    public void visit(PrintedBook book) {
        double weightInHundredGrams = 5.0;
        double cost = weightInHundredGrams * 0.5;
        this.totalShippingCost += cost;
    }

    @Override
    public void visit(Magazine magazine) {
        this.totalShippingCost += 2.0;
    }

    @Override
    public void visit(AudioBook audioBook) {
        if (audioBook.getQuality() == Media.MediaQuality.PHYSICAL) {
            double weightInHundredGrams = 1.0;
            double cost = weightInHundredGrams * 0.5;
            this.totalShippingCost += cost;
        } else {
            this.totalShippingCost += 0.0;
        }
    }

    @Override
    public void visit(VideoMaterial video) {
        if (video.getQuality() == Media.MediaQuality.PHYSICAL) {
            double weightInHundredGrams = 1.5;
            double cost = weightInHundredGrams * 0.5;
            this.totalShippingCost += cost;
        } else {
            this.totalShippingCost += 0.0;
        }
    }

    @Override
    public void visit(EBook ebook) {
        this.totalShippingCost += 0.0;
    }

    public double getTotalShippingCost() {
        return this.totalShippingCost;
    }

    public void reset() {
        this.totalShippingCost = 0.0;
    }

    public double calculateShippingCost(Material material) {
        this.reset();
        if (material instanceof PrintedBook) {
            this.visit((PrintedBook)material);
        } else if (material instanceof Magazine) {
            this.visit((Magazine)material);
        } else if (material instanceof AudioBook) {
            this.visit((AudioBook)material);
        } else if (material instanceof VideoMaterial) {
            this.visit((VideoMaterial)material);
        } else if (material instanceof EBook) {
            this.visit((EBook)material);
        } else {
            throw new IllegalArgumentException("Unknown material type: " + material.getClass().getSimpleName());
        }
        return this.totalShippingCost;
    }
}

