/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.utils;

import com.university.bookstore.model.Book;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

public final class BookArrayUtils {
    private BookArrayUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static int countBeforeYear(Book[] books, int yearCutoff) {
        if (books == null) {
            return 0;
        }
        int count = 0;
        for (Book book : books) {
            if (book == null || book.getYear() >= yearCutoff) continue;
            ++count;
        }
        return count;
    }

    public static int countByAuthor(Book[] books, String author) {
        if (books == null || author == null) {
            return 0;
        }
        int count = 0;
        for (Book book : books) {
            if (book == null || !book.getAuthor().equalsIgnoreCase(author)) continue;
            ++count;
        }
        return count;
    }

    public static Book[] filterPriceAtMost(Book[] books, double maxPrice) {
        if (maxPrice < 0.0) {
            throw new IllegalArgumentException("Max price cannot be negative");
        }
        if (books == null) {
            return new Book[0];
        }
        int count = 0;
        for (Book book : books) {
            if (book == null || !(book.getPrice() <= maxPrice)) continue;
            ++count;
        }
        Book[] result = new Book[count];
        int index = 0;
        for (Book book : books) {
            if (book == null || !(book.getPrice() <= maxPrice)) continue;
            result[index++] = book;
        }
        return result;
    }

    public static Book[] filterByDecade(Book[] books, int decade) {
        if (books == null) {
            return new Book[0];
        }
        int decadeEnd = decade + 9;
        int count = 0;
        for (Book book : books) {
            if (book == null || book.getYear() < decade || book.getYear() > decadeEnd) continue;
            ++count;
        }
        Book[] result = new Book[count];
        int index = 0;
        for (Book book : books) {
            if (book == null || book.getYear() < decade || book.getYear() > decadeEnd) continue;
            result[index++] = book;
        }
        return result;
    }

    public static void sortByPrice(Book[] books) {
        if (books == null || books.length <= 1) {
            return;
        }
        Arrays.sort(books, (a, b) -> {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return Double.compare(a.getPrice(), b.getPrice());
        });
    }

    public static void sortByYear(Book[] books) {
        if (books == null || books.length <= 1) {
            return;
        }
        Arrays.sort(books, (a, b) -> {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return Integer.compare(a.getYear(), b.getYear());
        });
    }

    public static double averagePrice(Book[] books) {
        if (books == null) {
            return 0.0;
        }
        double sum = 0.0;
        int count = 0;
        for (Book book : books) {
            if (book == null) continue;
            sum += book.getPrice();
            ++count;
        }
        return count == 0 ? 0.0 : sum / (double)count;
    }

    public static Book findOldest(Book[] books) {
        if (books == null) {
            return null;
        }
        Book oldest = null;
        for (Book book : books) {
            if (book == null || oldest != null && book.getYear() >= oldest.getYear()) continue;
            oldest = book;
        }
        return oldest;
    }

    public static Book[] merge(Book[] arr1, Book[] arr2) {
        int len1 = arr1 == null ? 0 : arr1.length;
        int len2 = arr2 == null ? 0 : arr2.length;
        Book[] result = new Book[len1 + len2];
        if (arr1 != null) {
            System.arraycopy(arr1, 0, result, 0, len1);
        }
        if (arr2 != null) {
            System.arraycopy(arr2, 0, result, len1, len2);
        }
        return result;
    }

    public static Book[] removeDuplicates(Book[] books) {
        if (books == null) {
            return new Book[0];
        }
        HashSet<String> seenIsbns = new HashSet<String>();
        ArrayList<Book> unique = new ArrayList<Book>();
        for (Book book : books) {
            if (book == null || !seenIsbns.add(book.getIsbn())) continue;
            unique.add(book);
        }
        return unique.toArray(new Book[0]);
    }

    public static Book[] filterByYearRange(Book[] books, int startYear, int endYear) {
        if (books == null || startYear > endYear) {
            return new Book[0];
        }
        return (Book[])Stream.of(books).filter(book -> book != null && book.getYear() >= startYear && book.getYear() <= endYear).toArray(Book[]::new);
    }

    public static Map<Integer, Integer> countByDecade(Book[] books) {
        TreeMap<Integer, Integer> decadeCounts = new TreeMap<Integer, Integer>();
        if (books != null) {
            for (Book book : books) {
                if (book == null) continue;
                int decade = book.getYear() / 10 * 10;
                decadeCounts.merge(decade, 1, Integer::sum);
            }
        }
        return decadeCounts;
    }

    public static Book findLongestTitle(Book[] books) {
        if (books == null) {
            return null;
        }
        Book longest = null;
        int maxLength = 0;
        for (Book book : books) {
            if (book == null || book.getTitle().length() <= maxLength) continue;
            maxLength = book.getTitle().length();
            longest = book;
        }
        return longest;
    }
}

