/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.service;

import com.university.bookstore.model.Material;
import com.university.bookstore.repository.MaterialRepository;
import java.util.List;
import java.util.Optional;

public class MaterialService {
    private final MaterialRepository repository;

    public MaterialService(MaterialRepository repository) {
        this.repository = repository;
    }

    public void addMaterial(Material material) {
        this.validateMaterial(material);
        this.repository.save(material);
    }

    public void updateMaterial(Material material) {
        this.validateMaterial(material);
        if (!this.repository.exists(material.getId())) {
            throw new MaterialNotFoundException("Material not found: " + material.getId());
        }
        this.repository.save(material);
    }

    public Material findMaterial(String id) {
        return this.repository.findById(id).orElseThrow(() -> new MaterialNotFoundException("Material not found: " + id));
    }

    public Optional<Material> findMaterialOptional(String id) {
        return this.repository.findById(id);
    }

    public List<Material> getAllMaterials() {
        return this.repository.findAll();
    }

    public boolean removeMaterial(String id) {
        return this.repository.delete(id);
    }

    public boolean materialExists(String id) {
        return this.repository.exists(id);
    }

    public long getMaterialCount() {
        return this.repository.count();
    }

    public void clearAllMaterials() {
        this.repository.deleteAll();
    }

    private void validateMaterial(Material material) {
        if (material == null) {
            throw new InvalidMaterialException("Material cannot be null");
        }
        if (material.getId() == null || material.getId().trim().isEmpty()) {
            throw new InvalidMaterialException("Material ID cannot be null or empty");
        }
        if (material.getTitle() == null || material.getTitle().trim().isEmpty()) {
            throw new InvalidMaterialException("Material title cannot be null or empty");
        }
        if (material.getCreator() == null || material.getCreator().trim().isEmpty()) {
            throw new InvalidMaterialException("Material creator cannot be null or empty");
        }
        if (material.getPrice() < 0.0) {
            throw new InvalidMaterialException("Material price cannot be negative: " + material.getPrice());
        }
        if (material.getYear() < 1000 || material.getYear() > 2100) {
            throw new InvalidMaterialException("Material year must be between 1000 and 2100: " + material.getYear());
        }
    }

    public static class MaterialNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MaterialNotFoundException(String message) {
            super(message);
        }

        public MaterialNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class InvalidMaterialException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidMaterialException(String message) {
            super(message);
        }

        public InvalidMaterialException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

