/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.search;

import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SearchResultCache {
    private final int maxSize;
    private final Map<String, CacheEntry> cache;
    private final Deque<String> accessOrder;

    public SearchResultCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Cache size must be positive: " + maxSize);
        }
        this.maxSize = maxSize;
        this.cache = new HashMap<String, CacheEntry>();
        this.accessOrder = new LinkedList<String>();
    }

    public Optional<List<Material>> get(String key) {
        if (key == null) {
            return Optional.empty();
        }
        CacheEntry entry = this.cache.get(key);
        if (entry != null) {
            this.accessOrder.remove(key);
            this.accessOrder.addLast(key);
            return Optional.of(new ArrayList<Material>(entry.results));
        }
        return Optional.empty();
    }

    public void put(String key, List<Material> results) {
        if (key == null) {
            throw new IllegalArgumentException("Cache key cannot be null");
        }
        if (results == null) {
            throw new IllegalArgumentException("Search results cannot be null");
        }
        if (this.cache.size() >= this.maxSize && !this.cache.containsKey(key)) {
            this.evictLRU();
        }
        this.cache.put(key, new CacheEntry(results));
        this.accessOrder.remove(key);
        this.accessOrder.addLast(key);
    }

    public boolean containsKey(String key) {
        return key != null && this.cache.containsKey(key);
    }

    public boolean remove(String key) {
        if (key == null) {
            return false;
        }
        CacheEntry removed = this.cache.remove(key);
        this.accessOrder.remove(key);
        return removed != null;
    }

    public void clear() {
        this.cache.clear();
        this.accessOrder.clear();
    }

    public int size() {
        return this.cache.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public boolean isFull() {
        return this.cache.size() >= this.maxSize;
    }

    public CacheStats getStats() {
        long totalRequests = 0L;
        long totalHits = 0L;
        long totalAge = 0L;
        long currentTime = System.currentTimeMillis();
        for (CacheEntry entry : this.cache.values()) {
            totalRequests += entry.accessCount;
            totalHits += entry.hitCount;
            totalAge += currentTime - entry.timestamp;
        }
        double hitRatio = totalRequests > 0L ? (double)totalHits / (double)totalRequests : 0.0;
        double averageAge = this.cache.size() > 0 ? (double)totalAge / (double)this.cache.size() : 0.0;
        return new CacheStats(this.cache.size(), this.maxSize, hitRatio, averageAge, totalRequests, totalHits);
    }

    private void evictLRU() {
        if (!this.accessOrder.isEmpty()) {
            String lruKey = this.accessOrder.removeFirst();
            this.cache.remove(lruKey);
        }
    }

    public String toString() {
        return String.format("SearchResultCache[Size=%d/%d, HitRatio=%.2f%%]", this.size(), this.maxSize, this.getStats().getHitRatio() * 100.0);
    }

    private static class CacheEntry {
        final List<Material> results;
        final long timestamp;
        long accessCount;
        long hitCount;

        CacheEntry(List<Material> results) {
            this.results = new ArrayList<Material>(results);
            this.timestamp = System.currentTimeMillis();
            this.accessCount = 0L;
            this.hitCount = 0L;
        }
    }

    public static class CacheStats {
        private final int currentSize;
        private final int maxSize;
        private final double hitRatio;
        private final double averageAge;
        private final long totalRequests;
        private final long totalHits;

        public CacheStats(int currentSize, int maxSize, double hitRatio, double averageAge, long totalRequests, long totalHits) {
            this.currentSize = currentSize;
            this.maxSize = maxSize;
            this.hitRatio = hitRatio;
            this.averageAge = averageAge;
            this.totalRequests = totalRequests;
            this.totalHits = totalHits;
        }

        public int getCurrentSize() {
            return this.currentSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public double getHitRatio() {
            return this.hitRatio;
        }

        public double getAverageAge() {
            return this.averageAge;
        }

        public long getTotalRequests() {
            return this.totalRequests;
        }

        public long getTotalHits() {
            return this.totalHits;
        }

        public String toString() {
            return String.format("CacheStats[Size=%d/%d, HitRatio=%.2f%%, AvgAge=%.0fms, Requests=%d, Hits=%d]", this.currentSize, this.maxSize, this.hitRatio * 100.0, this.averageAge, this.totalRequests, this.totalHits);
        }
    }
}

