/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.search;

import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MaterialTrie {
    private final TrieNode root = new TrieNode();

    public void insert(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        String title = material.getTitle().toLowerCase();
        TrieNode current = this.root;
        current.materials.add(material);
        for (char c : title.toCharArray()) {
            current.children.putIfAbsent(Character.valueOf(c), new TrieNode());
            current = current.children.get(Character.valueOf(c));
            current.materials.add(material);
        }
        current.isEndOfWord = true;
    }

    public List<Material> searchByPrefix(String prefix) {
        if (prefix == null || prefix.trim().isEmpty()) {
            return new ArrayList<Material>();
        }
        String lowerPrefix = prefix.toLowerCase().trim();
        TrieNode current = this.root;
        for (char c : lowerPrefix.toCharArray()) {
            if (!current.children.containsKey(Character.valueOf(c))) {
                return Collections.emptyList();
            }
            current = current.children.get(Character.valueOf(c));
        }
        return new ArrayList<Material>(current.materials);
    }

    public List<Material> searchByPrefixWithLimit(String prefix, int limit) {
        if (limit <= 0) {
            return new ArrayList<Material>();
        }
        List<Material> results = this.searchByPrefix(prefix);
        return results.stream().limit(limit).collect(Collectors.toList());
    }

    public boolean hasPrefix(String prefix) {
        if (prefix == null || prefix.trim().isEmpty()) {
            return false;
        }
        String lowerPrefix = prefix.toLowerCase().trim();
        TrieNode current = this.root;
        for (char c : lowerPrefix.toCharArray()) {
            if (!current.children.containsKey(Character.valueOf(c))) {
                return false;
            }
            current = current.children.get(Character.valueOf(c));
        }
        return !current.materials.isEmpty();
    }

    public List<Material> getAllMaterials() {
        return new ArrayList<Material>(this.root.materials);
    }

    public boolean remove(Material material) {
        if (material == null) {
            return false;
        }
        String title = material.getTitle().toLowerCase();
        ArrayList<TrieNode> path = new ArrayList<TrieNode>();
        TrieNode current = this.root;
        path.add(current);
        for (char c : title.toCharArray()) {
            if (!current.children.containsKey(Character.valueOf(c))) {
                return false;
            }
            current = current.children.get(Character.valueOf(c));
            path.add(current);
        }
        boolean removed = false;
        for (TrieNode node : path) {
            if (!node.materials.remove(material)) continue;
            removed = true;
        }
        this.cleanupEmptyNodes(path);
        return removed;
    }

    public void clear() {
        this.root.children.clear();
        this.root.materials.clear();
        this.root.isEndOfWord = false;
    }

    public int size() {
        return this.root.materials.size();
    }

    public boolean isEmpty() {
        return this.root.materials.isEmpty();
    }

    private void cleanupEmptyNodes(List<TrieNode> path) {
        for (int i = path.size() - 1; i > 0; --i) {
            TrieNode node = path.get(i);
            if (!node.materials.isEmpty() || !node.children.isEmpty()) continue;
            TrieNode parent = path.get(i - 1);
            parent.children.entrySet().removeIf(entry -> entry.getValue() == node);
        }
    }

    public String toString() {
        return String.format("MaterialTrie[Size=%d, Prefixes=%d]", this.size(), this.countPrefixes(this.root));
    }

    private int countPrefixes(TrieNode node) {
        int count = node.isEndOfWord ? 1 : 0;
        for (TrieNode child : node.children.values()) {
            count += this.countPrefixes(child);
        }
        return count;
    }

    private static class TrieNode {
        final Map<Character, TrieNode> children = new HashMap<Character, TrieNode>();
        final List<Material> materials = new ArrayList<Material>();
        boolean isEndOfWord = false;

        TrieNode() {
        }
    }
}

