/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.search;

import com.university.bookstore.model.Material;
import com.university.bookstore.repository.MaterialRepository;
import com.university.bookstore.search.MaterialTrie;
import com.university.bookstore.search.SearchResultCache;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CachedSearchService {
    private final MaterialTrie trie;
    private final SearchResultCache cache;
    private final MaterialRepository repository;

    public CachedSearchService(MaterialRepository repository, int cacheSize) {
        this.repository = Objects.requireNonNull(repository, "Repository cannot be null");
        this.trie = new MaterialTrie();
        this.cache = new SearchResultCache(cacheSize);
        this.initializeTrie();
    }

    public List<Material> searchByPrefix(String prefix) {
        if (prefix == null || prefix.trim().isEmpty()) {
            return List.of();
        }
        String cacheKey = "prefix:" + prefix.toLowerCase().trim();
        Optional<List<Material>> cached = this.cache.get(cacheKey);
        if (cached.isPresent()) {
            return cached.get();
        }
        List<Material> results = this.trie.searchByPrefix(prefix);
        this.cache.put(cacheKey, results);
        return results;
    }

    public List<Material> searchByPrefixWithLimit(String prefix, int limit) {
        if (prefix == null || prefix.trim().isEmpty() || limit <= 0) {
            return List.of();
        }
        String cacheKey = "prefix:" + prefix.toLowerCase().trim() + ":limit:" + limit;
        Optional<List<Material>> cached = this.cache.get(cacheKey);
        if (cached.isPresent()) {
            return cached.get();
        }
        List<Material> results = this.trie.searchByPrefixWithLimit(prefix, limit);
        this.cache.put(cacheKey, results);
        return results;
    }

    public void addMaterial(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        this.trie.insert(material);
        this.invalidateCacheForMaterial(material);
    }

    public void removeMaterial(Material material) {
        if (material == null) {
            return;
        }
        this.trie.remove(material);
        this.invalidateCacheForMaterial(material);
    }

    public void refreshIndex() {
        this.trie.clear();
        this.cache.clear();
        this.initializeTrie();
    }

    public SearchResultCache.CacheStats getCacheStats() {
        return this.cache.getStats();
    }

    public int getIndexSize() {
        return this.trie.size();
    }

    public boolean isIndexEmpty() {
        return this.trie.isEmpty();
    }

    public void clear() {
        this.trie.clear();
        this.cache.clear();
    }

    private void initializeTrie() {
        List<Material> materials = this.repository.findAll();
        for (Material material : materials) {
            this.trie.insert(material);
        }
    }

    private void invalidateCacheForMaterial(Material material) {
        String title = material.getTitle().toLowerCase();
        for (int i = 1; i <= title.length(); ++i) {
            String prefix = title.substring(0, i);
            String cacheKey = "prefix:" + prefix;
            this.cache.remove(cacheKey);
            for (int limit = 10; limit <= 100; limit += 10) {
                String limitCacheKey = cacheKey + ":limit:" + limit;
                this.cache.remove(limitCacheKey);
            }
        }
    }

    public String toString() {
        return String.format("CachedSearchService[IndexSize=%d, CacheSize=%d/%d, HitRatio=%.2f%%]", this.getIndexSize(), this.cache.size(), this.cache.getMaxSize(), this.getCacheStats().getHitRatio() * 100.0);
    }
}

