/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.observer;

import com.university.bookstore.model.Material;
import com.university.bookstore.observer.MaterialEvent;
import java.util.Objects;

public class PriceChangedEvent
implements MaterialEvent {
    private final Material material;
    private final double oldPrice;
    private final double newPrice;
    private final long timestamp;

    public PriceChangedEvent(Material material, double oldPrice, double newPrice) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        if (oldPrice < 0.0) {
            throw new IllegalArgumentException("Old price cannot be negative: " + oldPrice);
        }
        if (newPrice < 0.0) {
            throw new IllegalArgumentException("New price cannot be negative: " + newPrice);
        }
        this.oldPrice = oldPrice;
        this.newPrice = newPrice;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getEventType() {
        return "PRICE_CHANGED";
    }

    @Override
    public String getDescription() {
        return String.format("Price changed for %s: $%.2f -> $%.2f (Change: $%.2f)", this.material.getTitle(), this.oldPrice, this.newPrice, this.newPrice - this.oldPrice);
    }

    public double getOldPrice() {
        return this.oldPrice;
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public double getPriceChange() {
        return this.newPrice - this.oldPrice;
    }

    public double getPriceChangePercentage() {
        if (this.oldPrice == 0.0) {
            return this.newPrice > 0.0 ? 100.0 : 0.0;
        }
        return (this.newPrice - this.oldPrice) / this.oldPrice * 100.0;
    }

    public boolean isPriceIncrease() {
        return this.newPrice > this.oldPrice;
    }

    public boolean isPriceDecrease() {
        return this.newPrice < this.oldPrice;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PriceChangedEvent that = (PriceChangedEvent)obj;
        return Double.compare(that.oldPrice, this.oldPrice) == 0 && Double.compare(that.newPrice, this.newPrice) == 0 && this.timestamp == that.timestamp && Objects.equals(this.material, that.material);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.oldPrice, this.newPrice, this.timestamp);
    }

    public String toString() {
        return String.format("PriceChangedEvent[%s: $%.2f -> $%.2f at %d]", this.material.getTitle(), this.oldPrice, this.newPrice, this.timestamp);
    }
}

