/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.observer;

import com.university.bookstore.model.Material;
import com.university.bookstore.observer.MaterialAddedEvent;
import com.university.bookstore.observer.MaterialEvent;
import com.university.bookstore.observer.MaterialObserver;
import com.university.bookstore.observer.MaterialSubject;
import com.university.bookstore.observer.PriceChangedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialEventPublisher
implements MaterialSubject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaterialEventPublisher.class);
    private final List<MaterialObserver> observers = new CopyOnWriteArrayList<MaterialObserver>();

    @Override
    public void addObserver(MaterialObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException("Observer cannot be null");
        }
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
            observer.onAdded(this);
        }
    }

    @Override
    public boolean removeObserver(MaterialObserver observer) {
        if (observer == null) {
            return false;
        }
        boolean removed = this.observers.remove(observer);
        if (removed) {
            observer.onRemoved(this);
        }
        return removed;
    }

    @Override
    public void notifyObservers(MaterialEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        for (MaterialObserver observer : this.observers) {
            try {
                observer.onEvent(event);
            }
            catch (Exception e) {
                LOGGER.error("Observer {} failed to handle event: {}", new Object[]{observer.getObserverName(), event.getEventType(), e});
            }
        }
    }

    @Override
    public int getObserverCount() {
        return this.observers.size();
    }

    @Override
    public boolean hasNoObservers() {
        return this.observers.isEmpty();
    }

    @Override
    public void clearObservers() {
        for (MaterialObserver observer : this.observers) {
            try {
                observer.onRemoved(this);
            }
            catch (Exception e) {
                LOGGER.warn("Error notifying observer of removal", (Throwable)e);
            }
        }
        this.observers.clear();
    }

    public void publishMaterialAdded(Material material) {
        this.notifyObservers(new MaterialAddedEvent(material));
    }

    public void publishPriceChanged(Material material, double oldPrice, double newPrice) {
        this.notifyObservers(new PriceChangedEvent(material, oldPrice, newPrice));
    }

    public void publishEvent(MaterialEvent event) {
        this.notifyObservers(event);
    }

    public List<MaterialObserver> getObservers() {
        return new ArrayList<MaterialObserver>(this.observers);
    }

    public boolean hasObserver(MaterialObserver observer) {
        return this.observers.contains(observer);
    }

    public <T extends MaterialObserver> List<T> getObserversOfType(Class<T> observerType) {
        ArrayList<MaterialObserver> result = new ArrayList<MaterialObserver>();
        for (MaterialObserver observer : this.observers) {
            if (!observerType.isInstance(observer)) continue;
            result.add((MaterialObserver)observerType.cast(observer));
        }
        return result;
    }

    public String toString() {
        return String.format("MaterialEventPublisher[Observers=%d]", this.getObserverCount());
    }
}

