/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.observer;

import com.university.bookstore.model.Material;
import com.university.bookstore.observer.MaterialEvent;
import java.util.Objects;

public class MaterialAddedEvent
implements MaterialEvent {
    private final Material material;
    private final long timestamp;

    public MaterialAddedEvent(Material material) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getEventType() {
        return "MATERIAL_ADDED";
    }

    @Override
    public String getDescription() {
        return String.format("Material added: %s (ID: %s, Price: $%.2f)", this.material.getTitle(), this.material.getId(), this.material.getPrice());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterialAddedEvent that = (MaterialAddedEvent)obj;
        return this.timestamp == that.timestamp && Objects.equals(this.material, that.material);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.timestamp);
    }

    public String toString() {
        return String.format("MaterialAddedEvent[%s at %d]", this.material.getTitle(), this.timestamp);
    }
}

