/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.observer;

import com.university.bookstore.model.Material;
import com.university.bookstore.observer.MaterialEvent;
import com.university.bookstore.observer.MaterialObserver;
import com.university.bookstore.observer.PriceChangedEvent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryObserver
implements MaterialObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryObserver.class);
    private final Map<String, Integer> inventoryCounts = new HashMap<String, Integer>();
    private final Map<String, Double> totalValue = new HashMap<String, Double>();
    private int totalEvents = 0;

    @Override
    public void onEvent(MaterialEvent event) {
        ++this.totalEvents;
        switch (event.getEventType()) {
            case "MATERIAL_ADDED": {
                this.handleMaterialAdded(event);
                break;
            }
            case "PRICE_CHANGED": {
                this.handlePriceChanged(event);
                break;
            }
        }
    }

    private void handleMaterialAdded(MaterialEvent event) {
        Material material = event.getMaterial();
        String materialId = material.getId();
        this.inventoryCounts.merge(materialId, 1, Integer::sum);
        this.totalValue.merge(materialId, material.getPrice(), Double::sum);
        LOGGER.info("Inventory updated: {} count: {}", (Object)materialId, (Object)this.inventoryCounts.get(materialId));
    }

    private void handlePriceChanged(MaterialEvent event) {
        if (event instanceof PriceChangedEvent) {
            PriceChangedEvent priceEvent = (PriceChangedEvent)event;
            Material material = event.getMaterial();
            String materialId = material.getId();
            double priceChange = priceEvent.getPriceChange();
            this.totalValue.merge(materialId, priceChange, Double::sum);
            LOGGER.info("Price changed for {}: ${} -> ${}", new Object[]{material.getTitle(), priceEvent.getOldPrice(), priceEvent.getNewPrice()});
        }
    }

    public int getInventoryCount(String materialId) {
        return this.inventoryCounts.getOrDefault(materialId, 0);
    }

    public double getTotalValue(String materialId) {
        return this.totalValue.getOrDefault(materialId, 0.0);
    }

    public int getTotalInventoryCount() {
        return this.inventoryCounts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public double getTotalInventoryValue() {
        return this.totalValue.values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public int getUniqueMaterialCount() {
        return this.inventoryCounts.size();
    }

    public int getTotalEvents() {
        return this.totalEvents;
    }

    public Map<String, Integer> getAllInventoryCounts() {
        return new HashMap<String, Integer>(this.inventoryCounts);
    }

    public Map<String, Double> getAllTotalValues() {
        return new HashMap<String, Double>(this.totalValue);
    }

    public void clear() {
        this.inventoryCounts.clear();
        this.totalValue.clear();
        this.totalEvents = 0;
    }

    @Override
    public String getObserverName() {
        return "InventoryObserver";
    }

    public String toString() {
        return String.format("InventoryObserver[Materials=%d, TotalCount=%d, TotalValue=$%.2f, Events=%d]", this.getUniqueMaterialCount(), this.getTotalInventoryCount(), this.getTotalInventoryValue(), this.getTotalEvents());
    }
}

