/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.observer;

import com.university.bookstore.observer.MaterialEvent;
import com.university.bookstore.observer.MaterialObserver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogObserver
implements MaterialObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogObserver.class);
    private final List<AuditLogEntry> auditLog = new ArrayList<AuditLogEntry>();
    private final int maxLogSize;

    public AuditLogObserver() {
        this(Integer.MAX_VALUE);
    }

    public AuditLogObserver(int maxLogSize) {
        this.maxLogSize = maxLogSize;
    }

    @Override
    public void onEvent(MaterialEvent event) {
        if (event == null) {
            return;
        }
        AuditLogEntry entry = new AuditLogEntry(event.getTimestamp(), event.getEventType(), event.getMaterial().getId(), event.getMaterial().getTitle(), event.getDescription());
        this.auditLog.add(entry);
        if (this.auditLog.size() > this.maxLogSize) {
            this.auditLog.remove(0);
        }
    }

    public List<AuditLogEntry> getAuditLog() {
        return new ArrayList<AuditLogEntry>(this.auditLog);
    }

    public List<AuditLogEntry> getAuditLogForMaterial(String materialId) {
        return this.auditLog.stream().filter(entry -> Objects.equals(entry.getMaterialId(), materialId)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public List<AuditLogEntry> getAuditLogForEventType(String eventType) {
        return this.auditLog.stream().filter(entry -> Objects.equals(entry.getEventType(), eventType)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public List<AuditLogEntry> getAuditLogForTimeRange(long startTime, long endTime) {
        return this.auditLog.stream().filter(entry -> entry.getTimestamp() >= startTime && entry.getTimestamp() <= endTime).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public void printAuditLog() {
        this.auditLog.forEach(entry -> LOGGER.info("Audit: {}", (Object)entry.toString()));
    }

    public int getLogSize() {
        return this.auditLog.size();
    }

    public void clearAuditLog() {
        this.auditLog.clear();
    }

    public AuditLogStats getAuditLogStats() {
        int totalEntries = this.auditLog.size();
        int materialAddedCount = (int)this.auditLog.stream().filter(entry -> "MATERIAL_ADDED".equals(entry.getEventType())).count();
        int priceChangedCount = (int)this.auditLog.stream().filter(entry -> "PRICE_CHANGED".equals(entry.getEventType())).count();
        long oldestTimestamp = this.auditLog.stream().mapToLong(AuditLogEntry::getTimestamp).min().orElse(0L);
        long newestTimestamp = this.auditLog.stream().mapToLong(AuditLogEntry::getTimestamp).max().orElse(0L);
        return new AuditLogStats(totalEntries, materialAddedCount, priceChangedCount, oldestTimestamp, newestTimestamp);
    }

    @Override
    public String getObserverName() {
        return "AuditLogObserver";
    }

    public String toString() {
        return String.format("AuditLogObserver[LogSize=%d, MaxSize=%d]", this.getLogSize(), this.maxLogSize);
    }

    public static class AuditLogEntry {
        private final long timestamp;
        private final String eventType;
        private final String materialId;
        private final String materialTitle;
        private final String description;

        public AuditLogEntry(long timestamp, String eventType, String materialId, String materialTitle, String description) {
            this.timestamp = timestamp;
            this.eventType = eventType;
            this.materialId = materialId;
            this.materialTitle = materialTitle;
            this.description = description;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getEventType() {
            return this.eventType;
        }

        public String getMaterialId() {
            return this.materialId;
        }

        public String getMaterialTitle() {
            return this.materialTitle;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.format("[%s] %s: %s (ID: %s) - %s", new Date(this.timestamp), this.eventType, this.materialTitle, this.materialId, this.description);
        }
    }

    public static class AuditLogStats {
        private final int totalEntries;
        private final int materialAddedCount;
        private final int priceChangedCount;
        private final long oldestTimestamp;
        private final long newestTimestamp;

        public AuditLogStats(int totalEntries, int materialAddedCount, int priceChangedCount, long oldestTimestamp, long newestTimestamp) {
            this.totalEntries = totalEntries;
            this.materialAddedCount = materialAddedCount;
            this.priceChangedCount = priceChangedCount;
            this.oldestTimestamp = oldestTimestamp;
            this.newestTimestamp = newestTimestamp;
        }

        public int getTotalEntries() {
            return this.totalEntries;
        }

        public int getMaterialAddedCount() {
            return this.materialAddedCount;
        }

        public int getPriceChangedCount() {
            return this.priceChangedCount;
        }

        public long getOldestTimestamp() {
            return this.oldestTimestamp;
        }

        public long getNewestTimestamp() {
            return this.newestTimestamp;
        }

        public String toString() {
            return String.format("AuditLogStats[Total=%d, Added=%d, PriceChanged=%d, Oldest=%s, Newest=%s]", this.totalEntries, this.materialAddedCount, this.priceChangedCount, new Date(this.oldestTimestamp), new Date(this.newestTimestamp));
        }
    }
}

