/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.observer;

import com.university.bookstore.observer.MaterialEvent;
import com.university.bookstore.observer.MaterialObserver;
import java.util.HashMap;
import java.util.Map;

public class AnalyticsObserver
implements MaterialObserver {
    private final Map<String, Integer> eventCounts = new HashMap<String, Integer>();
    private final Map<String, Double> totalValue = new HashMap<String, Double>();
    private final Map<String, Integer> materialTypeCounts = new HashMap<String, Integer>();
    private int totalEvents = 0;
    private long firstEventTime = 0L;
    private long lastEventTime = 0L;

    @Override
    public void onEvent(MaterialEvent event) {
        ++this.totalEvents;
        long currentTime = event.getTimestamp();
        if (this.firstEventTime == 0L) {
            this.firstEventTime = currentTime;
        }
        this.lastEventTime = currentTime;
        String eventType = event.getEventType();
        this.eventCounts.merge(eventType, 1, Integer::sum);
        String materialId = event.getMaterial().getId();
        String materialType = event.getMaterial().getType().toString();
        if ("MATERIAL_ADDED".equals(eventType)) {
            this.totalValue.merge(materialId, event.getMaterial().getPrice(), Double::sum);
            this.materialTypeCounts.merge(materialType, 1, Integer::sum);
        }
    }

    public Map<String, Integer> getEventStatistics() {
        return new HashMap<String, Integer>(this.eventCounts);
    }

    public int getEventCount(String eventType) {
        return this.eventCounts.getOrDefault(eventType, 0);
    }

    public int getTotalEvents() {
        return this.totalEvents;
    }

    public double getTotalInventoryValue() {
        return this.totalValue.values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public Map<String, Integer> getMaterialTypeStatistics() {
        return new HashMap<String, Integer>(this.materialTypeCounts);
    }

    public int getMaterialTypeCount(String materialType) {
        return this.materialTypeCounts.getOrDefault(materialType, 0);
    }

    public int getUniqueMaterialCount() {
        return this.totalValue.size();
    }

    public long getFirstEventTime() {
        return this.firstEventTime;
    }

    public long getLastEventTime() {
        return this.lastEventTime;
    }

    public long getEventTimeSpan() {
        if (this.firstEventTime == 0L) {
            return 0L;
        }
        return this.lastEventTime - this.firstEventTime;
    }

    public double getAverageEventRate() {
        long timeSpan = this.getEventTimeSpan();
        if (timeSpan == 0L) {
            return 0.0;
        }
        return (double)this.totalEvents / ((double)timeSpan / 1000.0);
    }

    public AnalyticsData getAnalyticsData() {
        return new AnalyticsData(this.totalEvents, this.getTotalInventoryValue(), this.getUniqueMaterialCount(), this.getEventStatistics(), this.getMaterialTypeStatistics(), this.firstEventTime, this.lastEventTime, this.getEventTimeSpan(), this.getAverageEventRate());
    }

    public void clear() {
        this.eventCounts.clear();
        this.totalValue.clear();
        this.materialTypeCounts.clear();
        this.totalEvents = 0;
        this.firstEventTime = 0L;
        this.lastEventTime = 0L;
    }

    @Override
    public String getObserverName() {
        return "AnalyticsObserver";
    }

    public String toString() {
        return String.format("AnalyticsObserver[Events=%d, Materials=%d, Value=$%.2f]", this.getTotalEvents(), this.getUniqueMaterialCount(), this.getTotalInventoryValue());
    }

    public static class AnalyticsData {
        private final int totalEvents;
        private final double totalInventoryValue;
        private final int uniqueMaterialCount;
        private final Map<String, Integer> eventStatistics;
        private final Map<String, Integer> materialTypeStatistics;
        private final long firstEventTime;
        private final long lastEventTime;
        private final long eventTimeSpan;
        private final double averageEventRate;

        public AnalyticsData(int totalEvents, double totalInventoryValue, int uniqueMaterialCount, Map<String, Integer> eventStatistics, Map<String, Integer> materialTypeStatistics, long firstEventTime, long lastEventTime, long eventTimeSpan, double averageEventRate) {
            this.totalEvents = totalEvents;
            this.totalInventoryValue = totalInventoryValue;
            this.uniqueMaterialCount = uniqueMaterialCount;
            this.eventStatistics = new HashMap<String, Integer>(eventStatistics);
            this.materialTypeStatistics = new HashMap<String, Integer>(materialTypeStatistics);
            this.firstEventTime = firstEventTime;
            this.lastEventTime = lastEventTime;
            this.eventTimeSpan = eventTimeSpan;
            this.averageEventRate = averageEventRate;
        }

        public int getTotalEvents() {
            return this.totalEvents;
        }

        public double getTotalInventoryValue() {
            return this.totalInventoryValue;
        }

        public int getUniqueMaterialCount() {
            return this.uniqueMaterialCount;
        }

        public Map<String, Integer> getEventStatistics() {
            return new HashMap<String, Integer>(this.eventStatistics);
        }

        public Map<String, Integer> getMaterialTypeStatistics() {
            return new HashMap<String, Integer>(this.materialTypeStatistics);
        }

        public long getFirstEventTime() {
            return this.firstEventTime;
        }

        public long getLastEventTime() {
            return this.lastEventTime;
        }

        public long getEventTimeSpan() {
            return this.eventTimeSpan;
        }

        public double getAverageEventRate() {
            return this.averageEventRate;
        }

        public String toString() {
            return String.format("AnalyticsData[Events=%d, Value=$%.2f, Materials=%d, Rate=%.2f/s]", this.totalEvents, this.totalInventoryValue, this.uniqueMaterialCount, this.averageEventRate);
        }
    }
}

