/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.model;

import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import java.time.Year;
import java.util.Arrays;
import java.util.List;

public class VideoMaterial
extends Material
implements Media {
    private final String director;
    private final int duration;
    private final String format;
    private final double fileSize;
    private final Media.MediaQuality quality;
    private final VideoType videoType;
    private final String rating;
    private final List<String> cast;
    private final boolean subtitlesAvailable;
    private final String aspectRatio;

    public VideoMaterial(String id, String title, String director, double price, int year, int duration, String format, double fileSize, Media.MediaQuality quality, VideoType videoType, String rating, List<String> cast, boolean subtitlesAvailable, String aspectRatio) {
        super(id, title, price, year, videoType == VideoType.DOCUMENTARY ? Material.MaterialType.DOCUMENTARY : Material.MaterialType.VIDEO);
        this.director = this.validateStringField(director, "Director");
        this.duration = this.validateDuration(duration);
        this.format = this.validateStringField(format, "Format");
        this.fileSize = this.validateFileSize(fileSize);
        this.quality = quality != null ? quality : Media.MediaQuality.HD;
        this.videoType = videoType != null ? videoType : VideoType.MOVIE;
        this.rating = rating != null ? rating : "NR";
        this.cast = cast != null ? cast : Arrays.asList(new String[0]);
        this.subtitlesAvailable = subtitlesAvailable;
        this.aspectRatio = aspectRatio != null ? aspectRatio : "16:9";
    }

    private int validateDuration(int duration) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive. Provided: " + duration);
        }
        return duration;
    }

    private double validateFileSize(double fileSize) {
        if (fileSize <= 0.0) {
            throw new IllegalArgumentException("File size must be positive. Provided: " + fileSize);
        }
        return fileSize;
    }

    @Override
    public String getCreator() {
        return this.director;
    }

    @Override
    public String getDisplayInfo() {
        return String.format("%s (%d) - Directed by %s, %s, %d min, Rated %s, $%.2f", new Object[]{this.title, this.year, this.director, this.videoType, this.duration, this.rating, this.price});
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public double getFileSize() {
        return this.fileSize;
    }

    @Override
    public boolean isStreamingOnly() {
        return this.fileSize > 4096.0;
    }

    @Override
    public Media.MediaQuality getQuality() {
        return this.quality;
    }

    @Override
    public double getDiscountRate() {
        int currentYear = Year.now().getValue();
        if (this.year < currentYear - 5) {
            return 0.3;
        }
        if (this.year < currentYear - 2) {
            return 0.15;
        }
        return 0.0;
    }

    public boolean isFeatureLength() {
        return this.duration >= 60;
    }

    public double getStreamingBandwidth() {
        switch (this.quality) {
            case LOW: {
                return 1.5;
            }
            case STANDARD: {
                return 3.0;
            }
            case HIGH: {
                return 5.0;
            }
            case HD: {
                return 8.0;
            }
            case ULTRA_HD: {
                return 25.0;
            }
        }
        return 5.0;
    }

    public double getCompressedSize(double compressionRatio) {
        if (compressionRatio <= 0.0 || compressionRatio > 1.0) {
            throw new IllegalArgumentException("Compression ratio must be between 0 and 1");
        }
        return this.fileSize * compressionRatio;
    }

    public String getDirector() {
        return this.director;
    }

    public VideoType getVideoType() {
        return this.videoType;
    }

    public String getRating() {
        return this.rating;
    }

    public List<String> getCast() {
        return this.cast;
    }

    public boolean hasSubtitles() {
        return this.subtitlesAvailable;
    }

    public String getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public String toString() {
        return String.format("VideoMaterial[ID=%s, Title='%s', Director='%s', Type=%s, Duration=%dmin, Quality=%s, Rating=%s, Price=$%.2f]", new Object[]{this.id, this.title, this.director, this.videoType, this.duration, this.quality, this.rating, this.price});
    }

    public static enum VideoType {
        MOVIE("Movie"),
        DOCUMENTARY("Documentary"),
        EDUCATIONAL("Educational"),
        TV_SERIES("TV Series"),
        SHORT_FILM("Short Film"),
        TUTORIAL("Tutorial");

        private final String label;

        private VideoType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

