/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.university.bookstore.model.Material;
import java.time.Year;
import java.util.regex.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PrintedBook
extends Material {
    private static final Pattern ISBN_13_PATTERN = Pattern.compile("^\\d{13}$");
    private static final Pattern ISBN_10_PATTERN = Pattern.compile("^\\d{9}[\\dX]$");
    private final String isbn;
    private final String author;
    private final int pages;
    private final String publisher;
    private final boolean hardcover;

    @JsonCreator
    public PrintedBook(@JsonProperty(value="id") String isbn, @JsonProperty(value="title") String title, @JsonProperty(value="author") String author, @JsonProperty(value="price") double price, @JsonProperty(value="year") int year, @JsonProperty(value="pages") int pages, @JsonProperty(value="publisher") String publisher, @JsonProperty(value="hardcover") boolean hardcover) {
        super(PrintedBook.validateIsbn(isbn), title, price, year, Material.MaterialType.BOOK);
        this.isbn = this.id;
        this.author = this.validateStringField(author, "Author");
        this.pages = this.validatePages(pages);
        this.publisher = this.validateStringField(publisher, "Publisher");
        this.hardcover = hardcover;
    }

    public PrintedBook(String isbn, String title, String author, double price, int year) {
        this(isbn, title, author, price, year, 0, "Unknown", false);
    }

    private static String validateIsbn(String isbn) {
        if (isbn == null) {
            throw new NullPointerException("ISBN cannot be null");
        }
        String cleaned = isbn.replaceAll("-", "").trim();
        if (!ISBN_10_PATTERN.matcher(cleaned).matches() && !ISBN_13_PATTERN.matcher(cleaned).matches()) {
            throw new IllegalArgumentException("ISBN must be 10 or 13 digits. Provided: " + isbn);
        }
        return cleaned;
    }

    private int validatePages(int pages) {
        if (pages < 0) {
            throw new IllegalArgumentException("Pages cannot be negative");
        }
        return pages;
    }

    @Override
    public String getCreator() {
        return this.author;
    }

    @Override
    public String getDisplayInfo() {
        return String.format("%s by %s (%d, %s) - %d pages, $%.2f", this.title, this.author, this.year, this.hardcover ? "Hardcover" : "Paperback", this.pages, this.price);
    }

    @Override
    public double getDiscountRate() {
        int currentYear = Year.now().getValue();
        if (this.year < currentYear - 2) {
            return 0.15;
        }
        return 0.0;
    }

    public String getIsbn() {
        return this.isbn;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getPages() {
        return this.pages;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public boolean isHardcover() {
        return this.hardcover;
    }

    public double estimateReadingTime(int wordsPerMinute) {
        if (this.pages == 0 || wordsPerMinute <= 0) {
            return 0.0;
        }
        int avgWordsPerPage = 250;
        int totalWords = this.pages * avgWordsPerPage;
        return (double)totalWords / (double)(wordsPerMinute * 60);
    }

    @Override
    public String toString() {
        return String.format("PrintedBook[ISBN=%s, Title='%s', Author='%s', Price=$%.2f, Year=%d, Pages=%d, %s]", this.isbn, this.title, this.author, this.price, this.year, this.pages, this.hardcover ? "Hardcover" : "Paperback");
    }
}

