/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.model;

public interface Media {
    public int getDuration();

    public String getFormat();

    public double getFileSize();

    public boolean isStreamingOnly();

    public MediaQuality getQuality();

    default public String getPlaybackInfo() {
        return String.format("Duration: %d min, Format: %s, Quality: %s, Size: %.1f MB", new Object[]{this.getDuration(), this.getFormat(), this.getQuality(), this.getFileSize()});
    }

    default public int estimateDownloadTime(double mbps) {
        if (this.isStreamingOnly()) {
            return 0;
        }
        double megabits = this.getFileSize() * 8.0;
        return (int)Math.ceil(megabits / mbps);
    }

    public static enum MediaQuality {
        LOW("Low Quality", 64),
        MEDIUM("Medium Quality", 96),
        STANDARD("Standard Quality", 128),
        HIGH("High Quality", 256),
        HD("HD Quality", 320),
        ULTRA_HD("Ultra HD", 512),
        PHYSICAL("Physical Media", 0);

        private final String description;
        private final int bitrate;

        private MediaQuality(String description, int bitrate) {
            this.description = description;
            this.bitrate = bitrate;
        }

        public String getDescription() {
            return this.description;
        }

        public int getBitrate() {
            return this.bitrate;
        }

        public String toString() {
            return this.description;
        }
    }
}

