/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.university.bookstore.model.AudioBook;
import com.university.bookstore.model.EBook;
import com.university.bookstore.model.Magazine;
import com.university.bookstore.model.PrintedBook;
import com.university.bookstore.model.VideoMaterial;
import java.time.Year;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PrintedBook.class, name="PrintedBook"), @JsonSubTypes.Type(value=EBook.class, name="EBook"), @JsonSubTypes.Type(value=AudioBook.class, name="AudioBook"), @JsonSubTypes.Type(value=VideoMaterial.class, name="VideoMaterial"), @JsonSubTypes.Type(value=Magazine.class, name="Magazine")})
public abstract class Material
implements Comparable<Material> {
    protected static final int MIN_YEAR = 1450;
    protected final String id;
    protected final String title;
    protected final double price;
    protected final int year;
    protected final MaterialType type;

    protected Material(String id, String title, double price, int year, MaterialType type) {
        this.id = this.validateId(id);
        this.title = this.validateStringField(title, "Title");
        this.price = this.validatePrice(price);
        this.year = this.validateYear(year);
        this.type = Objects.requireNonNull(type, "Material type cannot be null");
    }

    public abstract String getCreator();

    public abstract String getDisplayInfo();

    public final double getDiscountedPrice() {
        return this.price * (1.0 - this.getDiscountRate());
    }

    public double getDiscountRate() {
        return 0.0;
    }

    protected String validateId(String id) {
        if (id == null) {
            throw new NullPointerException("ID cannot be null");
        }
        if (id.trim().isEmpty()) {
            throw new IllegalArgumentException("ID cannot be blank");
        }
        return id.trim();
    }

    protected String validateStringField(String value, String fieldName) {
        if (value == null) {
            throw new NullPointerException(fieldName + " cannot be null");
        }
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be blank");
        }
        return value.trim();
    }

    protected double validatePrice(double price) {
        if (price < 0.0) {
            throw new IllegalArgumentException("Price cannot be negative. Provided: " + price);
        }
        if (Double.isNaN(price) || Double.isInfinite(price)) {
            throw new IllegalArgumentException("Price must be a valid number. Provided: " + price);
        }
        return price;
    }

    protected int validateYear(int year) {
        int currentYear = Year.now().getValue();
        if (year < 1450 || year > currentYear + 1) {
            throw new IllegalArgumentException(String.format("Year must be between %d and %d. Provided: %d", 1450, currentYear + 1, year));
        }
        return year;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public double getPrice() {
        return this.price;
    }

    public int getYear() {
        return this.year;
    }

    public MaterialType getType() {
        return this.type;
    }

    @Override
    public int compareTo(Material other) {
        if (other == null) {
            throw new NullPointerException("Cannot compare to null Material");
        }
        int titleComparison = this.title.compareToIgnoreCase(other.title);
        if (titleComparison != 0) {
            return titleComparison;
        }
        return this.id.compareTo(other.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Material)) {
            return false;
        }
        Material other = (Material)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return String.format("%s[ID=%s, Title='%s', Price=$%.2f, Year=%d]", this.type.getDisplayName(), this.id, this.title, this.price, this.year);
    }

    public static enum MaterialType {
        BOOK("Book"),
        MAGAZINE("Magazine"),
        AUDIO_BOOK("Audio Book"),
        VIDEO("Video"),
        MUSIC_ALBUM("Music Album"),
        PODCAST("Podcast"),
        DOCUMENTARY("Documentary"),
        E_BOOK("E-Book"),
        EBOOK("EBook");

        private final String displayName;

        private MaterialType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

