/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.model;

import com.university.bookstore.model.Material;
import java.time.LocalDate;
import java.time.Year;

public class Magazine
extends Material {
    private final String issn;
    private final String publisher;
    private final int issueNumber;
    private final String frequency;
    private final String category;

    public Magazine(String issn, String title, String publisher, double price, int year, int issueNumber, String frequency, String category) {
        super(Magazine.validateIssn(issn), title, price, year, Material.MaterialType.MAGAZINE);
        this.issn = this.id;
        this.publisher = this.validateStringField(publisher, "Publisher");
        this.issueNumber = this.validateIssueNumber(issueNumber);
        this.frequency = this.validateStringField(frequency, "Frequency");
        this.category = this.validateStringField(category, "Category");
    }

    private static String validateIssn(String issn) {
        if (issn == null) {
            throw new NullPointerException("ISSN cannot be null");
        }
        String cleaned = issn.replaceAll("-", "").trim();
        if (cleaned.length() != 8) {
            throw new IllegalArgumentException("ISSN must be 8 characters. Provided: " + issn);
        }
        return cleaned;
    }

    private int validateIssueNumber(int issueNumber) {
        if (issueNumber <= 0) {
            throw new IllegalArgumentException("Issue number must be positive. Provided: " + issueNumber);
        }
        return issueNumber;
    }

    @Override
    public String getCreator() {
        return this.publisher;
    }

    @Override
    public String getDisplayInfo() {
        return String.format("%s - Issue #%d (%s %d) - %s, $%.2f", this.title, this.issueNumber, this.frequency, this.year, this.category, this.price);
    }

    @Override
    public double getDiscountRate() {
        int currentYear = Year.now().getValue();
        int currentMonth = LocalDate.now().getMonthValue();
        if (this.year < currentYear || this.year == currentYear && this.issueNumber < currentMonth - 2) {
            return 0.25;
        }
        return 0.0;
    }

    public double calculateAnnualSubscription() {
        int issuesPerYear = this.getIssuesPerYear();
        double fullPrice = this.price * (double)issuesPerYear;
        return fullPrice * 0.85;
    }

    private int getIssuesPerYear() {
        switch (this.frequency.toUpperCase()) {
            case "DAILY": {
                return 365;
            }
            case "WEEKLY": {
                return 52;
            }
            case "BI-WEEKLY": {
                return 26;
            }
            case "MONTHLY": {
                return 12;
            }
            case "QUARTERLY": {
                return 4;
            }
            case "ANNUAL": {
                return 1;
            }
        }
        return 12;
    }

    public String getIssn() {
        return this.issn;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public int getIssueNumber() {
        return this.issueNumber;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public String toString() {
        return String.format("Magazine[ISSN=%s, Title='%s', Publisher='%s', Issue=%d, %s, Category='%s', Price=$%.2f, Year=%d]", this.issn, this.title, this.publisher, this.issueNumber, this.frequency, this.category, this.price, this.year);
    }

    public static enum PublicationFrequency {
        DAILY("Daily"),
        WEEKLY("Weekly"),
        BIWEEKLY("Bi-weekly"),
        MONTHLY("Monthly"),
        QUARTERLY("Quarterly"),
        ANNUAL("Annual");

        private final String label;

        private PublicationFrequency(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

