/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EBook
extends Material
implements Media {
    private static final Set<String> VALID_FORMATS = Set.of("PDF", "EPUB", "MOBI");
    private static final int WORDS_PER_MINUTE = 250;
    private static final double DRM_FREE_DISCOUNT = 0.15;
    private final String author;
    private final String fileFormat;
    private final double fileSize;
    private final boolean drmEnabled;
    private final int wordCount;
    private final Media.MediaQuality quality;

    @JsonCreator
    public EBook(@JsonProperty(value="id") String id, @JsonProperty(value="title") String title, @JsonProperty(value="author") String author, @JsonProperty(value="price") double price, @JsonProperty(value="year") int year, @JsonProperty(value="fileFormat") String fileFormat, @JsonProperty(value="fileSize") double fileSize, @JsonProperty(value="drmEnabled") boolean drmEnabled, @JsonProperty(value="wordCount") int wordCount, @JsonProperty(value="quality") Media.MediaQuality quality) {
        super(id, title, price, year, Material.MaterialType.E_BOOK);
        this.author = this.validateStringField(author, "Author");
        this.fileFormat = this.validateFileFormat(fileFormat);
        this.fileSize = this.validateFileSize(fileSize);
        this.drmEnabled = drmEnabled;
        this.wordCount = this.validateWordCount(wordCount);
        this.quality = Objects.requireNonNull(quality, "Media quality cannot be null");
    }

    private String validateFileFormat(String format) {
        if (format == null) {
            throw new NullPointerException("File format cannot be null");
        }
        String upperFormat = format.trim().toUpperCase();
        if (!VALID_FORMATS.contains(upperFormat)) {
            throw new IllegalArgumentException(String.format("Unsupported file format: %s. Supported formats: %s", format, VALID_FORMATS));
        }
        return upperFormat;
    }

    private double validateFileSize(double size) {
        if (size <= 0.0) {
            throw new IllegalArgumentException(String.format("File size must be positive. Provided: %.2f MB", size));
        }
        if (Double.isNaN(size) || Double.isInfinite(size)) {
            throw new IllegalArgumentException(String.format("File size must be a valid number. Provided: %.2f MB", size));
        }
        return size;
    }

    private int validateWordCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException(String.format("Word count cannot be negative. Provided: %d", count));
        }
        return count;
    }

    @Override
    public String getCreator() {
        return this.author;
    }

    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getDisplayInfo() {
        return String.format("EBook: %s by %s (%s, %.1f MB, %s, %d words)", this.getTitle(), this.author, this.fileFormat, this.fileSize, this.drmEnabled ? "DRM" : "DRM-free", this.wordCount);
    }

    @Override
    public double getDiscountRate() {
        return this.drmEnabled ? 0.0 : 0.15;
    }

    public int getReadingTimeMinutes() {
        return this.wordCount / 250;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    @Override
    public double getFileSize() {
        return this.fileSize;
    }

    public boolean isDrmEnabled() {
        return this.drmEnabled;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    @Override
    public Media.MediaQuality getQuality() {
        return this.quality;
    }

    public String getDescription() {
        return String.format("Digital %s format book by %s. %s, %.1f MB. Estimated reading time: %d minutes.", this.fileFormat, this.author, this.drmEnabled ? "DRM protected" : "DRM-free", this.fileSize, this.getReadingTimeMinutes());
    }

    @Override
    public int getDuration() {
        return this.getReadingTimeMinutes();
    }

    @Override
    public String getFormat() {
        return this.fileFormat;
    }

    @Override
    public boolean isStreamingOnly() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EBook)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        EBook other = (EBook)obj;
        return Double.compare(other.fileSize, this.fileSize) == 0 && this.drmEnabled == other.drmEnabled && this.wordCount == other.wordCount && Objects.equals(this.author, other.author) && Objects.equals(this.fileFormat, other.fileFormat) && this.quality == other.quality;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.author, this.fileFormat, this.fileSize, this.drmEnabled, this.wordCount, this.quality});
    }

    @Override
    public String toString() {
        return String.format("EBook[ID=%s, Title='%s', Author='%s', Price=$%.2f, Year=%d, Format=%s, Size=%.1fMB, DRM=%s, Words=%d, Quality=%s]", new Object[]{this.getId(), this.getTitle(), this.author, this.getPrice(), this.getYear(), this.fileFormat, this.fileSize, this.drmEnabled, this.wordCount, this.quality});
    }
}

