/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.model;

import java.time.Year;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Book
implements Comparable<Book> {
    private static final Pattern ISBN_13_PATTERN = Pattern.compile("^\\d{13}$");
    private static final Pattern ISBN_10_PATTERN = Pattern.compile("^\\d{9}[\\dX]$");
    private static final int MIN_YEAR = 1450;
    private final String isbn;
    private final String title;
    private final String author;
    private final double price;
    private final int year;

    public Book(String isbn, String title, String author, double price, int year) {
        this.isbn = this.validateIsbn(isbn);
        this.title = this.validateStringField(title, "Title");
        this.author = this.validateStringField(author, "Author");
        this.price = this.validatePrice(price);
        this.year = this.validateYear(year);
    }

    private String validateIsbn(String isbn) {
        if (isbn == null) {
            throw new NullPointerException("ISBN cannot be null");
        }
        String cleaned = isbn.replaceAll("-", "").trim();
        if (!ISBN_10_PATTERN.matcher(cleaned).matches() && !ISBN_13_PATTERN.matcher(cleaned).matches()) {
            throw new IllegalArgumentException("ISBN must be 10 or 13 digits. Provided: " + isbn);
        }
        return cleaned;
    }

    private String validateStringField(String value, String fieldName) {
        if (value == null) {
            throw new NullPointerException(fieldName + " cannot be null");
        }
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be blank");
        }
        return value.trim();
    }

    private double validatePrice(double price) {
        if (price < 0.0) {
            throw new IllegalArgumentException("Price cannot be negative. Provided: " + price);
        }
        if (Double.isNaN(price) || Double.isInfinite(price)) {
            throw new IllegalArgumentException("Price must be a valid number. Provided: " + price);
        }
        return price;
    }

    private int validateYear(int year) {
        int currentYear = Year.now().getValue();
        if (year < 1450 || year > currentYear + 1) {
            throw new IllegalArgumentException(String.format("Year must be between %d and %d. Provided: %d", 1450, currentYear + 1, year));
        }
        return year;
    }

    public String getIsbn() {
        return this.isbn;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public double getPrice() {
        return this.price;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public int compareTo(Book other) {
        if (other == null) {
            throw new NullPointerException("Cannot compare to null Book");
        }
        return this.title.compareToIgnoreCase(other.title);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Book)) {
            return false;
        }
        Book other = (Book)obj;
        return this.isbn.equals(other.isbn);
    }

    public int hashCode() {
        return Objects.hash(this.isbn);
    }

    public String toString() {
        return String.format("Book[ISBN=%s, Title='%s', Author='%s', Price=$%.2f, Year=%d]", this.isbn, this.title, this.author, this.price, this.year);
    }
}

