/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.model;

import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;

public class AudioBook
extends Material
implements Media {
    private final String isbn;
    private final String author;
    private final String narrator;
    private final int duration;
    private final String format;
    private final double fileSize;
    private final boolean streamingOnly;
    private final Media.MediaQuality quality;
    private final String language;
    private final boolean unabridged;

    public AudioBook(String isbn, String title, String author, String narrator, double price, int year, int duration, String format, double fileSize, Media.MediaQuality quality, String language, boolean unabridged) {
        super(AudioBook.validateIsbn(isbn), title, price, year, Material.MaterialType.AUDIO_BOOK);
        this.isbn = this.id;
        this.author = this.validateStringField(author, "Author");
        this.narrator = this.validateStringField(narrator, "Narrator");
        this.duration = this.validateDuration(duration);
        this.format = this.validateStringField(format, "Format");
        this.fileSize = this.validateFileSize(fileSize);
        this.streamingOnly = false;
        this.quality = quality != null ? quality : Media.MediaQuality.STANDARD;
        this.language = this.validateStringField(language, "Language");
        this.unabridged = unabridged;
    }

    private static String validateIsbn(String isbn) {
        if (isbn == null) {
            throw new NullPointerException("ISBN cannot be null");
        }
        String cleaned = isbn.replaceAll("-", "").trim();
        if (cleaned.length() < 10 || cleaned.length() > 13) {
            throw new IllegalArgumentException("Invalid ISBN: " + isbn);
        }
        return cleaned;
    }

    private int validateDuration(int duration) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive. Provided: " + duration);
        }
        return duration;
    }

    private double validateFileSize(double fileSize) {
        if (fileSize <= 0.0) {
            throw new IllegalArgumentException("File size must be positive. Provided: " + fileSize);
        }
        return fileSize;
    }

    @Override
    public String getCreator() {
        return this.author + " (Narrated by " + this.narrator + ")";
    }

    @Override
    public String getDisplayInfo() {
        return String.format("%s by %s, narrated by %s - %s, %d hours %d minutes, $%.2f", this.title, this.author, this.narrator, this.unabridged ? "Unabridged" : "Abridged", this.duration / 60, this.duration % 60, this.price);
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public double getFileSize() {
        return this.fileSize;
    }

    @Override
    public boolean isStreamingOnly() {
        return this.streamingOnly;
    }

    @Override
    public Media.MediaQuality getQuality() {
        return this.quality;
    }

    @Override
    public double getDiscountRate() {
        if (!this.unabridged) {
            return 0.1;
        }
        return 0.0;
    }

    public int calculateListeningSessions(int minutesPerDay) {
        if (minutesPerDay <= 0) {
            return 0;
        }
        return (int)Math.ceil((double)this.duration / (double)minutesPerDay);
    }

    public int getAdjustedDuration(double speed) {
        if (speed <= 0.0) {
            throw new IllegalArgumentException("Speed must be positive");
        }
        return (int)Math.ceil((double)this.duration / speed);
    }

    public String getIsbn() {
        return this.isbn;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getNarrator() {
        return this.narrator;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isUnabridged() {
        return this.unabridged;
    }

    @Override
    public String toString() {
        return String.format("AudioBook[ISBN=%s, Title='%s', Author='%s', Narrator='%s', Duration=%dmin, Format=%s, %s, Price=$%.2f]", this.isbn, this.title, this.author, this.narrator, this.duration, this.format, this.unabridged ? "Unabridged" : "Abridged", this.price);
    }
}

