/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.iterator;

import com.university.bookstore.iterator.MaterialIterator;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;

public class PriceSortedIterator
implements MaterialIterator {
    private final List<Material> sortedMaterials;
    private int currentIndex;
    private final boolean ascending;

    public PriceSortedIterator(List<Material> materials, boolean ascending) {
        this.sortedMaterials = new ArrayList<Material>(materials);
        this.ascending = ascending;
        this.currentIndex = 0;
        Comparator<Material> priceComparator = Comparator.comparing(Material::getPrice);
        if (!ascending) {
            priceComparator = priceComparator.reversed();
        }
        this.sortedMaterials.sort(priceComparator);
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.sortedMaterials.size();
    }

    @Override
    public Material next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        return this.sortedMaterials.get(this.currentIndex++);
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
    }

    @Override
    public int getCurrentPosition() {
        return this.currentIndex;
    }

    @Override
    public int getTotalCount() {
        return this.sortedMaterials.size();
    }

    @Override
    public int getRemainingCount() {
        return this.sortedMaterials.size() - this.currentIndex;
    }

    @Override
    public boolean isAtBeginning() {
        return this.currentIndex == 0;
    }

    @Override
    public boolean isAtEnd() {
        return this.currentIndex >= this.sortedMaterials.size();
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public Material peek() {
        if (this.currentIndex >= this.sortedMaterials.size()) {
            throw new NoSuchElementException("No more elements");
        }
        return this.sortedMaterials.get(this.currentIndex);
    }

    public Material peekNext() {
        if (this.currentIndex + 1 >= this.sortedMaterials.size()) {
            throw new NoSuchElementException("No next element");
        }
        return this.sortedMaterials.get(this.currentIndex + 1);
    }

    public String toString() {
        return String.format("PriceSortedIterator[Order=%s, Position=%d/%d]", this.ascending ? "ASC" : "DESC", this.getCurrentPosition(), this.getTotalCount());
    }
}

