/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.iterator;

import com.university.bookstore.iterator.MaterialIterator;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class PriceRangeIterator
implements MaterialIterator {
    private final List<Material> materials;
    private final double minPrice;
    private final double maxPrice;
    private int currentIndex;
    private final int totalCount;

    public PriceRangeIterator(List<Material> materials, double minPrice, double maxPrice) {
        if (minPrice < 0.0 || maxPrice < 0.0 || minPrice > maxPrice) {
            throw new IllegalArgumentException("Invalid price range: " + minPrice + " to " + maxPrice);
        }
        this.materials = new ArrayList<Material>(materials);
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
        this.currentIndex = 0;
        this.totalCount = (int)materials.stream().filter(m -> m.getPrice() >= minPrice && m.getPrice() <= maxPrice).count();
        this.advanceToNext();
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.materials.size();
    }

    @Override
    public Material next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        Material current = this.materials.get(this.currentIndex);
        ++this.currentIndex;
        this.advanceToNext();
        return current;
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
        this.advanceToNext();
    }

    @Override
    public int getCurrentPosition() {
        return this.currentIndex;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int getRemainingCount() {
        return this.totalCount - this.getCurrentPosition();
    }

    @Override
    public boolean isAtBeginning() {
        return this.currentIndex == 0;
    }

    @Override
    public boolean isAtEnd() {
        return this.currentIndex >= this.materials.size();
    }

    public double getMinPrice() {
        return this.minPrice;
    }

    public double getMaxPrice() {
        return this.maxPrice;
    }

    public double getPriceRange() {
        return this.maxPrice - this.minPrice;
    }

    private void advanceToNext() {
        Material material;
        while (!(this.currentIndex >= this.materials.size() || (material = this.materials.get(this.currentIndex)).getPrice() >= this.minPrice && material.getPrice() <= this.maxPrice)) {
            ++this.currentIndex;
        }
    }

    public String toString() {
        return String.format("PriceRangeIterator[Range=$%.2f-$%.2f, Position=%d/%d]", this.minPrice, this.maxPrice, this.getCurrentPosition(), this.getTotalCount());
    }
}

