/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.iterator;

import com.university.bookstore.iterator.MaterialIterator;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class MaterialTypeIterator
implements MaterialIterator {
    private final List<Material> materials;
    private final Material.MaterialType targetType;
    private int currentIndex;
    private final int totalCount;

    public MaterialTypeIterator(List<Material> materials, Material.MaterialType targetType) {
        this.materials = new ArrayList<Material>(materials);
        this.targetType = targetType;
        this.currentIndex = 0;
        this.totalCount = (int)materials.stream().filter(m -> m.getType() == targetType).count();
        this.advanceToNext();
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.materials.size();
    }

    @Override
    public Material next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        Material current = this.materials.get(this.currentIndex);
        ++this.currentIndex;
        this.advanceToNext();
        return current;
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
        this.advanceToNext();
    }

    @Override
    public int getCurrentPosition() {
        return this.currentIndex;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int getRemainingCount() {
        return this.totalCount - this.getCurrentPosition();
    }

    @Override
    public boolean isAtBeginning() {
        return this.currentIndex == 0;
    }

    @Override
    public boolean isAtEnd() {
        return this.currentIndex >= this.materials.size();
    }

    public Material.MaterialType getTargetType() {
        return this.targetType;
    }

    private void advanceToNext() {
        while (this.currentIndex < this.materials.size() && this.materials.get(this.currentIndex).getType() != this.targetType) {
            ++this.currentIndex;
        }
    }

    public String toString() {
        return String.format("MaterialTypeIterator[Type=%s, Position=%d/%d]", new Object[]{this.targetType, this.getCurrentPosition(), this.getTotalCount()});
    }
}

