/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.iterator;

import com.university.bookstore.iterator.MaterialIterator;
import com.university.bookstore.iterator.MaterialTypeIterator;
import com.university.bookstore.iterator.PriceRangeIterator;
import com.university.bookstore.iterator.PriceSortedIterator;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class MaterialIteratorFactory {
    public MaterialIterator createTypeIterator(List<Material> materials, Material.MaterialType type) {
        return new MaterialTypeIterator(materials, type);
    }

    public MaterialIterator createPriceSortedIterator(List<Material> materials, boolean ascending) {
        return new PriceSortedIterator(materials, ascending);
    }

    public MaterialIterator createPriceRangeIterator(List<Material> materials, double minPrice, double maxPrice) {
        return new PriceRangeIterator(materials, minPrice, maxPrice);
    }

    public MaterialIterator createEBookIterator(List<Material> materials) {
        return new MaterialTypeIterator(materials, Material.MaterialType.E_BOOK);
    }

    public MaterialIterator createExpensiveIterator(List<Material> materials, double threshold) {
        return new PriceRangeIterator(materials, threshold, Double.MAX_VALUE);
    }

    public MaterialIterator createCheapIterator(List<Material> materials, double threshold) {
        return new PriceRangeIterator(materials, 0.0, threshold);
    }

    public MaterialIterator createBookIterator(List<Material> materials) {
        return new MaterialTypeIterator(materials, Material.MaterialType.BOOK);
    }

    public MaterialIterator createMagazineIterator(List<Material> materials) {
        return new MaterialTypeIterator(materials, Material.MaterialType.MAGAZINE);
    }

    public MaterialIterator createAudioBookIterator(List<Material> materials) {
        return new MaterialTypeIterator(materials, Material.MaterialType.AUDIO_BOOK);
    }

    public MaterialIterator createVideoIterator(List<Material> materials) {
        return new MaterialTypeIterator(materials, Material.MaterialType.VIDEO);
    }

    public List<Material> collectAll(MaterialIterator iterator) {
        ArrayList<Material> result = new ArrayList<Material>();
        iterator.reset();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public Optional<Material> findFirst(MaterialIterator iterator, Predicate<Material> predicate) {
        iterator.reset();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (!predicate.test(material)) continue;
            return Optional.of(material);
        }
        return Optional.empty();
    }

    public List<Material> findAll(MaterialIterator iterator, Predicate<Material> predicate) {
        ArrayList<Material> result = new ArrayList<Material>();
        iterator.reset();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (!predicate.test(material)) continue;
            result.add(material);
        }
        return result;
    }

    public int count(MaterialIterator iterator, Predicate<Material> predicate) {
        int count = 0;
        iterator.reset();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (!predicate.test(material)) continue;
            ++count;
        }
        return count;
    }

    public boolean anyMatch(MaterialIterator iterator, Predicate<Material> predicate) {
        iterator.reset();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (!predicate.test(material)) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(MaterialIterator iterator, Predicate<Material> predicate) {
        iterator.reset();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (predicate.test(material)) continue;
            return false;
        }
        return true;
    }

    public int getTotalCount(MaterialIterator iterator) {
        return iterator.getTotalCount();
    }

    public int getRemainingCount(MaterialIterator iterator) {
        return iterator.getRemainingCount();
    }

    public String toString() {
        return "MaterialIteratorFactory[Available iterators: Type, PriceSorted, PriceRange, EBook, Expensive, Cheap, Book, Magazine, AudioBook, Video]";
    }
}

