/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.impl;

import com.university.bookstore.api.MaterialStore;
import com.university.bookstore.model.Magazine;
import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import com.university.bookstore.model.PrintedBook;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MaterialStoreImpl
implements MaterialStore {
    private final List<Material> inventory = new ArrayList<Material>();
    private final Map<String, Material> idIndex = new HashMap<String, Material>();

    public MaterialStoreImpl() {
    }

    public MaterialStoreImpl(Collection<Material> initialMaterials) {
        this();
        if (initialMaterials != null) {
            for (Material material : initialMaterials) {
                this.addMaterial(material);
            }
        }
    }

    @Override
    public synchronized boolean addMaterial(Material material) {
        if (material == null) {
            throw new NullPointerException("Cannot add null material");
        }
        if (this.idIndex.containsKey(material.getId())) {
            return false;
        }
        this.inventory.add(material);
        this.idIndex.put(material.getId(), material);
        return true;
    }

    @Override
    public synchronized Optional<Material> removeMaterial(String id) {
        if (id == null) {
            return Optional.empty();
        }
        Material material = this.idIndex.remove(id);
        if (material != null) {
            this.inventory.remove(material);
            return Optional.of(material);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Material> findById(String id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.idIndex.get(id));
    }

    @Override
    public List<Material> searchByTitle(String title) {
        if (title == null || title.trim().isEmpty()) {
            return new ArrayList<Material>();
        }
        String searchTerm = title.toLowerCase().trim();
        return this.inventory.stream().filter(m -> m.getTitle().toLowerCase().contains(searchTerm)).collect(Collectors.toList());
    }

    @Override
    public List<Material> searchByCreator(String creator) {
        if (creator == null || creator.trim().isEmpty()) {
            return new ArrayList<Material>();
        }
        String searchTerm = creator.toLowerCase().trim();
        return this.inventory.stream().filter(m -> m.getCreator().toLowerCase().contains(searchTerm)).collect(Collectors.toList());
    }

    @Override
    public List<Material> getMaterialsByType(Material.MaterialType type) {
        if (type == null) {
            return new ArrayList<Material>();
        }
        return this.inventory.stream().filter(m -> m.getType() == type).collect(Collectors.toList());
    }

    @Override
    public List<Media> getMediaMaterials() {
        return this.inventory.stream().filter(m -> m instanceof Media).map(m -> (Media)((Object)m)).collect(Collectors.toList());
    }

    @Override
    public List<Material> filterMaterials(Predicate<Material> predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate cannot be null");
        }
        return this.inventory.stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public List<Material> getMaterialsByPriceRange(double minPrice, double maxPrice) {
        if (minPrice < 0.0 || maxPrice < 0.0 || minPrice > maxPrice) {
            return new ArrayList<Material>();
        }
        return this.inventory.stream().filter(m -> m.getPrice() >= minPrice && m.getPrice() <= maxPrice).collect(Collectors.toList());
    }

    @Override
    public List<Material> getMaterialsByYear(int year) {
        return this.inventory.stream().filter(m -> m.getYear() == year).collect(Collectors.toList());
    }

    @Override
    public List<Material> getAllMaterialsSorted() {
        ArrayList<Material> sorted = new ArrayList<Material>(this.inventory);
        Collections.sort(sorted);
        return sorted;
    }

    @Override
    public List<Material> getAllMaterials() {
        return new ArrayList<Material>(this.inventory);
    }

    @Override
    public double getTotalInventoryValue() {
        return this.inventory.stream().mapToDouble(Material::getPrice).sum();
    }

    @Override
    public double getTotalDiscountedValue() {
        return this.inventory.stream().mapToDouble(Material::getDiscountedPrice).sum();
    }

    @Override
    public MaterialStore.InventoryStats getInventoryStats() {
        if (this.inventory.isEmpty()) {
            return new MaterialStore.InventoryStats(0, 0.0, 0.0, 0, 0, 0);
        }
        List prices = this.inventory.stream().map(Material::getPrice).sorted().collect(Collectors.toList());
        double averagePrice = prices.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        double medianPrice = prices.size() % 2 == 0 ? ((Double)prices.get(prices.size() / 2 - 1) + (Double)prices.get(prices.size() / 2)) / 2.0 : (Double)prices.get(prices.size() / 2);
        int uniqueTypes = (int)this.inventory.stream().map(Material::getType).distinct().count();
        int mediaCount = (int)this.inventory.stream().filter(m -> m instanceof Media).count();
        int printCount = (int)this.inventory.stream().filter(m -> m instanceof PrintedBook || m instanceof Magazine).count();
        return new MaterialStore.InventoryStats(this.inventory.size(), averagePrice, medianPrice, uniqueTypes, mediaCount, printCount);
    }

    @Override
    public synchronized void clearInventory() {
        this.inventory.clear();
        this.idIndex.clear();
    }

    @Override
    public int size() {
        return this.inventory.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    @Override
    public List<Material> findRecentMaterials(int years) {
        if (years < 0) {
            throw new IllegalArgumentException("Years cannot be negative: " + years);
        }
        int currentYear = Year.now().getValue();
        int cutoffYear = currentYear - years;
        return this.inventory.stream().filter(material -> material.getYear() >= cutoffYear).collect(Collectors.toList());
    }

    @Override
    public List<Material> findByCreators(String ... creators) {
        if (creators == null || creators.length == 0) {
            return new ArrayList<Material>();
        }
        Set creatorSet = Arrays.stream(creators).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        if (creatorSet.isEmpty()) {
            return new ArrayList<Material>();
        }
        return this.inventory.stream().filter(material -> creatorSet.contains(material.getCreator())).collect(Collectors.toList());
    }

    @Override
    public List<Material> findWithPredicate(Predicate<Material> condition) {
        if (condition == null) {
            throw new NullPointerException("Predicate cannot be null");
        }
        return this.inventory.stream().filter(condition).collect(Collectors.toList());
    }

    @Override
    public List<Material> getSorted(Comparator<Material> comparator) {
        if (comparator == null) {
            throw new NullPointerException("Comparator cannot be null");
        }
        return this.inventory.stream().sorted(comparator).collect(Collectors.toList());
    }

    public List<String> getAllDisplayInfo() {
        return this.inventory.stream().map(Material::getDisplayInfo).collect(Collectors.toList());
    }

    public Map<Material.MaterialType, List<Material>> groupByType() {
        return this.inventory.stream().collect(Collectors.groupingBy(Material::getType));
    }

    public List<Material> getDiscountedMaterials() {
        return this.inventory.stream().filter(m -> m.getDiscountRate() > 0.0).collect(Collectors.toList());
    }

    public double getTotalDiscountAmount() {
        return this.inventory.stream().mapToDouble(m -> m.getPrice() * m.getDiscountRate()).sum();
    }

    public String toString() {
        return String.format("MaterialStore[Size=%d, Types=%d, Value=$%.2f]", this.size(), this.groupByType().size(), this.getTotalInventoryValue());
    }
}

