/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.impl;

import com.university.bookstore.api.MaterialStore;
import com.university.bookstore.model.Magazine;
import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import com.university.bookstore.model.PrintedBook;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ConcurrentMaterialStore
implements MaterialStore {
    private final Map<String, Material> materials = new ConcurrentHashMap<String, Material>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public ConcurrentMaterialStore() {
    }

    public ConcurrentMaterialStore(Collection<Material> initialMaterials) {
        this();
        if (initialMaterials != null) {
            for (Material material : initialMaterials) {
                this.addMaterial(material);
            }
        }
    }

    @Override
    public boolean addMaterial(Material material) {
        if (material == null) {
            throw new NullPointerException("Cannot add null material");
        }
        this.writeLock.lock();
        try {
            boolean bl = this.materials.putIfAbsent(material.getId(), material) == null;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Optional<Material> removeMaterial(String id) {
        if (id == null) {
            return Optional.empty();
        }
        this.writeLock.lock();
        try {
            Optional<Material> optional = Optional.ofNullable(this.materials.remove(id));
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Optional<Material> findById(String id) {
        if (id == null) {
            return Optional.empty();
        }
        this.readLock.lock();
        try {
            Optional<Material> optional = Optional.ofNullable(this.materials.get(id));
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Material> searchByTitle(String title) {
        if (title == null || title.trim().isEmpty()) {
            return new ArrayList<Material>();
        }
        String searchTerm = title.toLowerCase().trim();
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(m -> m.getTitle().toLowerCase().contains(searchTerm)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Material> searchByCreator(String creator) {
        if (creator == null || creator.trim().isEmpty()) {
            return new ArrayList<Material>();
        }
        String searchTerm = creator.toLowerCase().trim();
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(m -> m.getCreator().toLowerCase().contains(searchTerm)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Material> getMaterialsByType(Material.MaterialType type) {
        if (type == null) {
            return new ArrayList<Material>();
        }
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(m -> m.getType() == type).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Media> getMediaMaterials() {
        this.readLock.lock();
        try {
            List<Media> list = this.materials.values().stream().filter(m -> m instanceof Media).map(m -> (Media)((Object)m)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Material> filterMaterials(Predicate<Material> predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate cannot be null");
        }
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(predicate).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Material> getMaterialsByPriceRange(double minPrice, double maxPrice) {
        if (minPrice < 0.0 || maxPrice < 0.0 || minPrice > maxPrice) {
            return new ArrayList<Material>();
        }
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(m -> m.getPrice() >= minPrice && m.getPrice() <= maxPrice).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Material> getMaterialsByYear(int year) {
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(m -> m.getYear() == year).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Material> getAllMaterialsSorted() {
        this.readLock.lock();
        try {
            ArrayList<Material> sorted = new ArrayList<Material>(this.materials.values());
            Collections.sort(sorted);
            ArrayList<Material> arrayList = sorted;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Material> getAllMaterials() {
        this.readLock.lock();
        try {
            ArrayList<Material> arrayList = new ArrayList<Material>(this.materials.values());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public double getTotalInventoryValue() {
        this.readLock.lock();
        try {
            double d = this.materials.values().stream().mapToDouble(Material::getPrice).sum();
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public double getTotalDiscountedValue() {
        this.readLock.lock();
        try {
            double d = this.materials.values().stream().mapToDouble(Material::getDiscountedPrice).sum();
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MaterialStore.InventoryStats getInventoryStats() {
        this.readLock.lock();
        try {
            if (this.materials.isEmpty()) {
                MaterialStore.InventoryStats inventoryStats = new MaterialStore.InventoryStats(0, 0.0, 0.0, 0, 0, 0);
                return inventoryStats;
            }
            List prices = this.materials.values().stream().map(Material::getPrice).sorted().collect(Collectors.toList());
            double averagePrice = prices.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            double medianPrice = prices.size() % 2 == 0 ? ((Double)prices.get(prices.size() / 2 - 1) + (Double)prices.get(prices.size() / 2)) / 2.0 : (Double)prices.get(prices.size() / 2);
            int uniqueTypes = (int)this.materials.values().stream().map(Material::getType).distinct().count();
            int mediaCount = (int)this.materials.values().stream().filter(m -> m instanceof Media).count();
            int printCount = (int)this.materials.values().stream().filter(m -> m instanceof PrintedBook || m instanceof Magazine).count();
            MaterialStore.InventoryStats inventoryStats = new MaterialStore.InventoryStats(this.materials.size(), averagePrice, medianPrice, uniqueTypes, mediaCount, printCount);
            return inventoryStats;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clearInventory() {
        this.writeLock.lock();
        try {
            this.materials.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.materials.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.materials.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Material> findRecentMaterials(int years) {
        if (years < 0) {
            throw new IllegalArgumentException("Years cannot be negative: " + years);
        }
        int currentYear = Year.now().getValue();
        int cutoffYear = currentYear - years;
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(material -> material.getYear() >= cutoffYear).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Material> findByCreators(String ... creators) {
        if (creators == null || creators.length == 0) {
            return new ArrayList<Material>();
        }
        Set creatorSet = Arrays.stream(creators).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        if (creatorSet.isEmpty()) {
            return new ArrayList<Material>();
        }
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(material -> creatorSet.contains(material.getCreator())).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Material> findWithPredicate(Predicate<Material> condition) {
        if (condition == null) {
            throw new NullPointerException("Predicate cannot be null");
        }
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(condition).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Material> getSorted(Comparator<Material> comparator) {
        if (comparator == null) {
            throw new NullPointerException("Comparator cannot be null");
        }
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().sorted(comparator).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<String> getAllDisplayInfo() {
        this.readLock.lock();
        try {
            List<String> list = this.materials.values().stream().map(Material::getDisplayInfo).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<Material.MaterialType, List<Material>> groupByType() {
        this.readLock.lock();
        try {
            Map<Material.MaterialType, List<Material>> map = this.materials.values().stream().collect(Collectors.groupingBy(Material::getType));
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Material> getDiscountedMaterials() {
        this.readLock.lock();
        try {
            List<Material> list = this.materials.values().stream().filter(m -> m.getDiscountRate() > 0.0).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public double getTotalDiscountAmount() {
        this.readLock.lock();
        try {
            double d = this.materials.values().stream().mapToDouble(m -> m.getPrice() * m.getDiscountRate()).sum();
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = String.format("ConcurrentMaterialStore[Size=%d, Types=%d, Value=$%.2f]", this.size(), this.groupByType().size(), this.getTotalInventoryValue());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

