/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.impl;

import com.university.bookstore.api.BookstoreAPI;
import com.university.bookstore.model.Book;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BookstoreArrayList
implements BookstoreAPI {
    private final List<Book> inventory = new ArrayList<Book>();

    public BookstoreArrayList() {
    }

    public BookstoreArrayList(Collection<Book> initialBooks) {
        if (initialBooks != null) {
            for (Book book : initialBooks) {
                this.add(book);
            }
        }
    }

    @Override
    public boolean add(Book book) {
        if (book == null) {
            return false;
        }
        if (this.findByIsbn(book.getIsbn()) != null) {
            return false;
        }
        return this.inventory.add(book);
    }

    @Override
    public boolean removeByIsbn(String isbn) {
        if (isbn == null || isbn.trim().isEmpty()) {
            return false;
        }
        return this.inventory.removeIf(book -> book.getIsbn().equals(isbn));
    }

    @Override
    public Book findByIsbn(String isbn) {
        if (isbn == null || isbn.trim().isEmpty()) {
            return null;
        }
        for (Book book : this.inventory) {
            if (!book.getIsbn().equals(isbn)) continue;
            return book;
        }
        return null;
    }

    @Override
    public List<Book> findByTitle(String titleQuery) {
        if (titleQuery == null || titleQuery.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String query = titleQuery.toLowerCase().trim();
        return this.inventory.stream().filter(book -> book.getTitle().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    @Override
    public List<Book> findByAuthor(String authorQuery) {
        if (authorQuery == null || authorQuery.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String query = authorQuery.toLowerCase().trim();
        return this.inventory.stream().filter(book -> book.getAuthor().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    @Override
    public List<Book> findByPriceRange(double minPrice, double maxPrice) {
        if (minPrice < 0.0 || maxPrice < 0.0) {
            throw new IllegalArgumentException("Prices cannot be negative");
        }
        if (minPrice > maxPrice) {
            throw new IllegalArgumentException("Minimum price cannot be greater than maximum price");
        }
        return this.inventory.stream().filter(book -> book.getPrice() >= minPrice && book.getPrice() <= maxPrice).collect(Collectors.toList());
    }

    @Override
    public List<Book> findByYear(int year) {
        return this.inventory.stream().filter(book -> book.getYear() == year).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.inventory.size();
    }

    @Override
    public double inventoryValue() {
        return this.inventory.stream().mapToDouble(Book::getPrice).sum();
    }

    @Override
    public Book getMostExpensive() {
        return this.inventory.stream().max(Comparator.comparingDouble(Book::getPrice)).orElse(null);
    }

    @Override
    public Book getMostRecent() {
        return this.inventory.stream().max(Comparator.comparingInt(Book::getYear)).orElse(null);
    }

    @Override
    public Book[] snapshotArray() {
        return this.inventory.toArray(new Book[0]);
    }

    @Override
    public List<Book> getAllBooks() {
        return new ArrayList<Book>(this.inventory);
    }

    public void clear() {
        this.inventory.clear();
    }

    public void sortByTitle() {
        Collections.sort(this.inventory);
    }

    public void sortByPrice() {
        this.inventory.sort(Comparator.comparingDouble(Book::getPrice));
    }

    public void sortByYear() {
        this.inventory.sort(Comparator.comparingInt(Book::getYear));
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("size", this.size());
        stats.put("total_value", this.inventoryValue());
        stats.put("average_price", this.inventory.isEmpty() ? 0.0 : this.inventoryValue() / (double)this.size());
        if (!this.inventory.isEmpty()) {
            stats.put("min_year", this.inventory.stream().mapToInt(Book::getYear).min().orElse(0));
            stats.put("max_year", this.inventory.stream().mapToInt(Book::getYear).max().orElse(0));
            stats.put("unique_authors", this.inventory.stream().map(Book::getAuthor).distinct().count());
        }
        return stats;
    }

    public String toString() {
        return String.format("BookstoreArrayList[size=%d, value=$%.2f]", this.size(), this.inventoryValue());
    }
}

