/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.factory;

import com.university.bookstore.model.AudioBook;
import com.university.bookstore.model.EBook;
import com.university.bookstore.model.Magazine;
import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import com.university.bookstore.model.PrintedBook;
import com.university.bookstore.model.VideoMaterial;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MaterialFactory {
    public static Material createMaterial(String type, Map<String, Object> properties) {
        String normalizedType;
        if (type == null) {
            throw new NullPointerException("Material type cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("Properties cannot be null");
        }
        switch (normalizedType = type.trim().toUpperCase()) {
            case "BOOK": 
            case "PRINTED_BOOK": {
                return MaterialFactory.createPrintedBook(properties);
            }
            case "MAGAZINE": {
                return MaterialFactory.createMagazine(properties);
            }
            case "AUDIO_BOOK": 
            case "AUDIOBOOK": {
                return MaterialFactory.createAudioBook(properties);
            }
            case "VIDEO": 
            case "VIDEO_MATERIAL": {
                return MaterialFactory.createVideoMaterial(properties);
            }
            case "EBOOK": 
            case "E_BOOK": {
                return MaterialFactory.createEBook(properties);
            }
        }
        throw new IllegalArgumentException("Unsupported material type: " + type);
    }

    private static PrintedBook createPrintedBook(Map<String, Object> properties) {
        String isbn = MaterialFactory.getRequiredString(properties, "isbn");
        String title = MaterialFactory.getRequiredString(properties, "title");
        String author = MaterialFactory.getRequiredString(properties, "author");
        double price = MaterialFactory.getRequiredDouble(properties, "price");
        int year = MaterialFactory.getRequiredInteger(properties, "year");
        int pages = MaterialFactory.getRequiredInteger(properties, "pages");
        String publisher = MaterialFactory.getOptionalString(properties, "publisher", "Unknown");
        boolean hardcover = MaterialFactory.getOptionalBoolean(properties, "hardcover", false);
        return new PrintedBook(isbn, title, author, price, year, pages, publisher, hardcover);
    }

    private static Magazine createMagazine(Map<String, Object> properties) {
        String issn = MaterialFactory.getRequiredString(properties, "issn");
        String title = MaterialFactory.getRequiredString(properties, "title");
        String publisher = MaterialFactory.getRequiredString(properties, "publisher");
        double price = MaterialFactory.getRequiredDouble(properties, "price");
        int year = MaterialFactory.getRequiredInteger(properties, "year");
        int issue = MaterialFactory.getRequiredInteger(properties, "issue");
        String frequency = MaterialFactory.getOptionalString(properties, "frequency", "Monthly");
        String category = MaterialFactory.getOptionalString(properties, "category", "General");
        return new Magazine(issn, title, publisher, price, year, issue, frequency, category);
    }

    private static AudioBook createAudioBook(Map<String, Object> properties) {
        String isbn = MaterialFactory.getRequiredString(properties, "isbn");
        String title = MaterialFactory.getRequiredString(properties, "title");
        String author = MaterialFactory.getRequiredString(properties, "author");
        String narrator = MaterialFactory.getRequiredString(properties, "narrator");
        double price = MaterialFactory.getRequiredDouble(properties, "price");
        int year = MaterialFactory.getRequiredInteger(properties, "year");
        int duration = MaterialFactory.getRequiredInteger(properties, "duration");
        String format = MaterialFactory.getOptionalString(properties, "format", "MP3");
        double fileSize = MaterialFactory.getOptionalDouble(properties, "fileSize", 100.0);
        Media.MediaQuality quality = MaterialFactory.getRequiredMediaQuality(properties, "quality");
        String language = MaterialFactory.getOptionalString(properties, "language", "English");
        boolean unabridged = MaterialFactory.getOptionalBoolean(properties, "unabridged", true);
        return new AudioBook(isbn, title, author, narrator, price, year, duration, format, fileSize, quality, language, unabridged);
    }

    private static VideoMaterial createVideoMaterial(Map<String, Object> properties) {
        String id = MaterialFactory.getRequiredString(properties, "id");
        String title = MaterialFactory.getRequiredString(properties, "title");
        String director = MaterialFactory.getRequiredString(properties, "director");
        double price = MaterialFactory.getRequiredDouble(properties, "price");
        int year = MaterialFactory.getRequiredInteger(properties, "year");
        int duration = MaterialFactory.getRequiredInteger(properties, "duration");
        String format = MaterialFactory.getOptionalString(properties, "format", "MP4");
        double fileSize = MaterialFactory.getOptionalDouble(properties, "fileSize", 1000.0);
        Media.MediaQuality quality = MaterialFactory.getRequiredMediaQuality(properties, "quality");
        VideoMaterial.VideoType videoType = MaterialFactory.getRequiredVideoType(properties, "videoType");
        String rating = MaterialFactory.getOptionalString(properties, "rating", "PG");
        List<String> cast = MaterialFactory.getOptionalStringList(properties, "cast");
        boolean subtitlesAvailable = MaterialFactory.getOptionalBoolean(properties, "subtitlesAvailable", false);
        String aspectRatio = MaterialFactory.getOptionalString(properties, "aspectRatio", "16:9");
        return new VideoMaterial(id, title, director, price, year, duration, format, fileSize, quality, videoType, rating, cast, subtitlesAvailable, aspectRatio);
    }

    private static EBook createEBook(Map<String, Object> properties) {
        String id = MaterialFactory.getRequiredString(properties, "id");
        String title = MaterialFactory.getRequiredString(properties, "title");
        String author = MaterialFactory.getRequiredString(properties, "author");
        double price = MaterialFactory.getRequiredDouble(properties, "price");
        int year = MaterialFactory.getRequiredInteger(properties, "year");
        String fileFormat = MaterialFactory.getRequiredString(properties, "fileFormat");
        double fileSize = MaterialFactory.getRequiredDouble(properties, "fileSize");
        boolean drmEnabled = MaterialFactory.getRequiredBoolean(properties, "drmEnabled");
        int wordCount = MaterialFactory.getRequiredInteger(properties, "wordCount");
        Media.MediaQuality quality = MaterialFactory.getRequiredMediaQuality(properties, "quality");
        return new EBook(id, title, author, price, year, fileFormat, fileSize, drmEnabled, wordCount, quality);
    }

    private static String getRequiredString(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new NullPointerException("Required property '" + key + "' is missing");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Property '" + key + "' must be a String, got: " + value.getClass().getSimpleName());
        }
        String str = (String)value;
        if (str.trim().isEmpty()) {
            throw new IllegalArgumentException("Property '" + key + "' cannot be empty");
        }
        return str.trim();
    }

    private static double getRequiredDouble(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new NullPointerException("Required property '" + key + "' is missing");
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property '" + key + "' must be a valid number, got: " + String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("Property '" + key + "' must be a number, got: " + value.getClass().getSimpleName());
    }

    private static int getRequiredInteger(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new NullPointerException("Required property '" + key + "' is missing");
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property '" + key + "' must be a valid integer, got: " + String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("Property '" + key + "' must be an integer, got: " + value.getClass().getSimpleName());
    }

    private static boolean getRequiredBoolean(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new NullPointerException("Required property '" + key + "' is missing");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = ((String)value).trim().toLowerCase();
            if ("true".equals(str) || "1".equals(str) || "yes".equals(str)) {
                return true;
            }
            if ("false".equals(str) || "0".equals(str) || "no".equals(str)) {
                return false;
            }
            throw new IllegalArgumentException("Property '" + key + "' must be a valid boolean, got: " + String.valueOf(value));
        }
        throw new IllegalArgumentException("Property '" + key + "' must be a boolean, got: " + value.getClass().getSimpleName());
    }

    private static Media.MediaQuality getRequiredMediaQuality(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new NullPointerException("Required property '" + key + "' is missing");
        }
        if (value instanceof Media.MediaQuality) {
            return (Media.MediaQuality)((Object)value);
        }
        if (value instanceof String) {
            try {
                return Media.MediaQuality.valueOf(((String)value).trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Property '" + key + "' must be a valid MediaQuality, got: " + String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("Property '" + key + "' must be a MediaQuality, got: " + value.getClass().getSimpleName());
    }

    private static String getOptionalString(Map<String, Object> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Property '" + key + "' must be a String, got: " + value.getClass().getSimpleName());
        }
        String str = (String)value;
        return str.trim().isEmpty() ? defaultValue : str.trim();
    }

    private static boolean getOptionalBoolean(Map<String, Object> properties, String key, boolean defaultValue) {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = ((String)value).trim().toLowerCase();
            if ("true".equals(str) || "1".equals(str) || "yes".equals(str)) {
                return true;
            }
            if ("false".equals(str) || "0".equals(str) || "no".equals(str)) {
                return false;
            }
            throw new IllegalArgumentException("Property '" + key + "' must be a valid boolean, got: " + String.valueOf(value));
        }
        throw new IllegalArgumentException("Property '" + key + "' must be a boolean, got: " + value.getClass().getSimpleName());
    }

    private static double getOptionalDouble(Map<String, Object> properties, String key, double defaultValue) {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property '" + key + "' must be a valid number, got: " + String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("Property '" + key + "' must be a number, got: " + value.getClass().getSimpleName());
    }

    private static VideoMaterial.VideoType getRequiredVideoType(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new NullPointerException("Required property '" + key + "' is missing");
        }
        if (value instanceof VideoMaterial.VideoType) {
            return (VideoMaterial.VideoType)((Object)value);
        }
        if (value instanceof String) {
            try {
                return VideoMaterial.VideoType.valueOf(((String)value).trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Property '" + key + "' must be a valid VideoType, got: " + String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("Property '" + key + "' must be a VideoType, got: " + value.getClass().getSimpleName());
    }

    private static List<String> getOptionalStringList(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            return Arrays.asList(new String[0]);
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.trim().isEmpty()) {
                return Arrays.asList(new String[0]);
            }
            return Arrays.asList(str.split(","));
        }
        throw new IllegalArgumentException("Property '" + key + "' must be a List<String> or String, got: " + value.getClass().getSimpleName());
    }
}

