/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.factory;

import com.university.bookstore.model.AudioBook;
import com.university.bookstore.model.EBook;
import com.university.bookstore.model.Magazine;
import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import com.university.bookstore.model.PrintedBook;
import com.university.bookstore.model.VideoMaterial;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdvancedMaterialFactory {
    public static Material createMaterial(String type, Map<String, Object> properties) {
        String normalizedType;
        Objects.requireNonNull(type, "Material type cannot be null");
        Objects.requireNonNull(properties, "Properties cannot be null");
        switch (normalizedType = type.trim().toUpperCase()) {
            case "BOOK": 
            case "PRINTED_BOOK": {
                return AdvancedMaterialFactory.createPrintedBook(properties);
            }
            case "EBOOK": 
            case "E_BOOK": {
                return AdvancedMaterialFactory.createEBook(properties);
            }
            case "AUDIOBOOK": 
            case "AUDIO_BOOK": {
                return AdvancedMaterialFactory.createAudioBook(properties);
            }
            case "VIDEO": 
            case "VIDEO_MATERIAL": {
                return AdvancedMaterialFactory.createVideoMaterial(properties);
            }
            case "MAGAZINE": {
                return AdvancedMaterialFactory.createMagazine(properties);
            }
        }
        throw new IllegalArgumentException("Unknown material type: " + type);
    }

    private static PrintedBook createPrintedBook(Map<String, Object> properties) {
        return new PrintedBook(AdvancedMaterialFactory.getRequiredString(properties, "id"), AdvancedMaterialFactory.getRequiredString(properties, "title"), AdvancedMaterialFactory.getRequiredString(properties, "author"), AdvancedMaterialFactory.getRequiredDouble(properties, "price"), AdvancedMaterialFactory.getRequiredInt(properties, "year"), AdvancedMaterialFactory.getRequiredInt(properties, "pages"), AdvancedMaterialFactory.getRequiredString(properties, "publisher"), AdvancedMaterialFactory.getRequiredBoolean(properties, "hardcover"));
    }

    private static EBook createEBook(Map<String, Object> properties) {
        return new EBook(AdvancedMaterialFactory.getRequiredString(properties, "id"), AdvancedMaterialFactory.getRequiredString(properties, "title"), AdvancedMaterialFactory.getRequiredString(properties, "author"), AdvancedMaterialFactory.getRequiredDouble(properties, "price"), AdvancedMaterialFactory.getRequiredInt(properties, "year"), AdvancedMaterialFactory.getRequiredString(properties, "fileFormat"), AdvancedMaterialFactory.getRequiredDouble(properties, "fileSize"), AdvancedMaterialFactory.getRequiredBoolean(properties, "drmEnabled"), AdvancedMaterialFactory.getRequiredInt(properties, "wordCount"), AdvancedMaterialFactory.getRequiredEnum(properties, "quality", Media.MediaQuality.class));
    }

    private static AudioBook createAudioBook(Map<String, Object> properties) {
        return new AudioBook(AdvancedMaterialFactory.getRequiredString(properties, "id"), AdvancedMaterialFactory.getRequiredString(properties, "title"), AdvancedMaterialFactory.getRequiredString(properties, "author"), AdvancedMaterialFactory.getRequiredString(properties, "narrator"), AdvancedMaterialFactory.getRequiredDouble(properties, "price"), AdvancedMaterialFactory.getRequiredInt(properties, "year"), AdvancedMaterialFactory.getRequiredInt(properties, "duration"), AdvancedMaterialFactory.getRequiredString(properties, "format"), AdvancedMaterialFactory.getRequiredDouble(properties, "fileSize"), AdvancedMaterialFactory.getRequiredEnum(properties, "quality", Media.MediaQuality.class), AdvancedMaterialFactory.getRequiredString(properties, "language"), AdvancedMaterialFactory.getRequiredBoolean(properties, "unabridged"));
    }

    private static VideoMaterial createVideoMaterial(Map<String, Object> properties) {
        return new VideoMaterial(AdvancedMaterialFactory.getRequiredString(properties, "id"), AdvancedMaterialFactory.getRequiredString(properties, "title"), AdvancedMaterialFactory.getRequiredString(properties, "director"), AdvancedMaterialFactory.getRequiredDouble(properties, "price"), AdvancedMaterialFactory.getRequiredInt(properties, "year"), AdvancedMaterialFactory.getRequiredInt(properties, "duration"), AdvancedMaterialFactory.getRequiredString(properties, "format"), AdvancedMaterialFactory.getRequiredDouble(properties, "fileSize"), AdvancedMaterialFactory.getRequiredEnum(properties, "quality", Media.MediaQuality.class), AdvancedMaterialFactory.getRequiredEnum(properties, "videoType", VideoMaterial.VideoType.class), AdvancedMaterialFactory.getRequiredString(properties, "rating"), AdvancedMaterialFactory.getRequiredStringList(properties, "cast"), AdvancedMaterialFactory.getRequiredBoolean(properties, "subtitlesAvailable"), AdvancedMaterialFactory.getRequiredString(properties, "aspectRatio"));
    }

    private static Magazine createMagazine(Map<String, Object> properties) {
        return new Magazine(AdvancedMaterialFactory.getRequiredString(properties, "id"), AdvancedMaterialFactory.getRequiredString(properties, "title"), AdvancedMaterialFactory.getRequiredString(properties, "publisher"), AdvancedMaterialFactory.getRequiredDouble(properties, "price"), AdvancedMaterialFactory.getRequiredInt(properties, "year"), AdvancedMaterialFactory.getRequiredInt(properties, "issue"), AdvancedMaterialFactory.getRequiredString(properties, "frequency"), AdvancedMaterialFactory.getRequiredString(properties, "category"));
    }

    private static String getRequiredString(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Required property missing: " + key);
        }
        String str = value.toString().trim();
        if (str.isEmpty()) {
            throw new IllegalArgumentException("Required property cannot be empty: " + key);
        }
        return str;
    }

    private static double getRequiredDouble(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Required property missing: " + key);
        }
        if (value instanceof Number) {
            double result = ((Number)value).doubleValue();
            if (result < 0.0) {
                throw new IllegalArgumentException("Property " + key + " must be non-negative: " + result);
            }
            return result;
        }
        throw new IllegalArgumentException("Property " + key + " must be a number");
    }

    private static int getRequiredInt(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Required property missing: " + key);
        }
        if (value instanceof Number) {
            int result = ((Number)value).intValue();
            if (result < 0) {
                throw new IllegalArgumentException("Property " + key + " must be non-negative: " + result);
            }
            return result;
        }
        throw new IllegalArgumentException("Property " + key + " must be a number");
    }

    private static boolean getRequiredBoolean(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Required property missing: " + key);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Property " + key + " must be a boolean");
    }

    private static <T extends Enum<T>> T getRequiredEnum(Map<String, Object> properties, String key, Class<T> enumClass) {
        Object value = properties.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Required property missing: " + key);
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(enumClass, value.toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Property " + key + " must be a valid " + enumClass.getSimpleName() + ": " + String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("Property " + key + " must be a string");
    }

    private static List<String> getRequiredStringList(Map<String, Object> properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Required property missing: " + key);
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof String) {
            String str = value.toString().trim();
            if (str.isEmpty()) {
                return Arrays.asList(new String[0]);
            }
            return Arrays.asList(str.split(","));
        }
        throw new IllegalArgumentException("Property " + key + " must be a list or string");
    }

    public static void validateRequiredProperties(String type, Map<String, Object> properties) {
        String normalizedType;
        switch (normalizedType = type.trim().toUpperCase()) {
            case "BOOK": 
            case "PRINTED_BOOK": {
                AdvancedMaterialFactory.validatePrintedBookProperties(properties);
                break;
            }
            case "EBOOK": 
            case "E_BOOK": {
                AdvancedMaterialFactory.validateEBookProperties(properties);
                break;
            }
            case "AUDIOBOOK": 
            case "AUDIO_BOOK": {
                AdvancedMaterialFactory.validateAudioBookProperties(properties);
                break;
            }
            case "VIDEO": 
            case "VIDEO_MATERIAL": {
                AdvancedMaterialFactory.validateVideoMaterialProperties(properties);
                break;
            }
            case "MAGAZINE": {
                AdvancedMaterialFactory.validateMagazineProperties(properties);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown material type: " + type);
            }
        }
    }

    private static void validatePrintedBookProperties(Map<String, Object> properties) {
        String[] required = new String[]{"id", "title", "author", "price", "year", "pages", "publisher", "hardcover"};
        AdvancedMaterialFactory.validateRequiredKeys(properties, required);
    }

    private static void validateEBookProperties(Map<String, Object> properties) {
        String[] required = new String[]{"id", "title", "author", "price", "year", "fileFormat", "fileSize", "drmEnabled", "wordCount", "quality"};
        AdvancedMaterialFactory.validateRequiredKeys(properties, required);
    }

    private static void validateAudioBookProperties(Map<String, Object> properties) {
        String[] required = new String[]{"id", "title", "author", "narrator", "price", "year", "duration", "format", "fileSize", "quality", "language", "unabridged"};
        AdvancedMaterialFactory.validateRequiredKeys(properties, required);
    }

    private static void validateVideoMaterialProperties(Map<String, Object> properties) {
        String[] required = new String[]{"id", "title", "director", "price", "year", "duration", "format", "fileSize", "quality", "videoType", "rating", "cast", "subtitlesAvailable", "aspectRatio"};
        AdvancedMaterialFactory.validateRequiredKeys(properties, required);
    }

    private static void validateMagazineProperties(Map<String, Object> properties) {
        String[] required = new String[]{"id", "title", "publisher", "price", "year", "issue", "frequency", "category"};
        AdvancedMaterialFactory.validateRequiredKeys(properties, required);
    }

    private static void validateRequiredKeys(Map<String, Object> properties, String[] requiredKeys) {
        for (String key : requiredKeys) {
            if (properties.containsKey(key)) continue;
            throw new IllegalArgumentException("Required property missing: " + key);
        }
    }
}

