/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.decorator;

import com.university.bookstore.decorator.DigitalAnnotationDecorator;
import com.university.bookstore.decorator.ExpeditedDeliveryDecorator;
import com.university.bookstore.decorator.GiftWrappingDecorator;
import com.university.bookstore.decorator.MaterialDecorator;
import com.university.bookstore.model.EBook;
import com.university.bookstore.model.Material;

public class MaterialEnhancementService {
    public Material addGiftWrapping(Material material, String style) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        if (style == null || style.trim().isEmpty()) {
            throw new IllegalArgumentException("Wrapping style cannot be null or empty");
        }
        return new GiftWrappingDecorator(material, style);
    }

    public Material addExpeditedDelivery(Material material, int deliveryDays) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        if (deliveryDays < 1) {
            throw new IllegalArgumentException("Delivery days must be at least 1: " + deliveryDays);
        }
        return new ExpeditedDeliveryDecorator(material, deliveryDays);
    }

    public Material addDigitalAnnotations(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        return new DigitalAnnotationDecorator(material);
    }

    public Material createPremiumPackage(Material material, String giftStyle, int deliveryDays) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        Material enhanced = material;
        enhanced = this.addGiftWrapping(enhanced, giftStyle);
        enhanced = this.addExpeditedDelivery(enhanced, deliveryDays);
        if (material instanceof EBook) {
            enhanced = this.addDigitalAnnotations(enhanced);
        }
        return enhanced;
    }

    public Material createGiftPackage(Material material, String giftStyle, int deliveryDays) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        Material enhanced = material;
        enhanced = this.addGiftWrapping(enhanced, giftStyle);
        enhanced = this.addExpeditedDelivery(enhanced, deliveryDays);
        return enhanced;
    }

    public Material createDigitalPackage(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        if (material instanceof EBook) {
            return this.addDigitalAnnotations(material);
        }
        return material;
    }

    public double calculateEnhancementCost(Material original, Material enhanced) {
        if (original == null || enhanced == null) {
            throw new IllegalArgumentException("Materials cannot be null");
        }
        return enhanced.getPrice() - original.getPrice();
    }

    public String getEnhancementSummary(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        StringBuilder summary = new StringBuilder();
        if (!this.hasEnhancements(material)) {
            summary.append("No enhancements applied");
            return summary.toString();
        }
        summary.append("Enhancements:\n");
        String displayInfo = material.getDisplayInfo();
        if (displayInfo.contains("Gift Wrapped")) {
            summary.append("// [OK] Gift Wrapping\n");
        }
        if (displayInfo.contains("Expedited Delivery")) {
            summary.append("// [OK] Expedited Delivery\n");
        }
        if (displayInfo.contains("Digital Annotations")) {
            summary.append("// [OK] Digital Annotations\n");
        }
        double enhancementCost = material.getPrice() - this.getBasePrice(material);
        summary.append("Total Cost: $").append(String.format("%.2f", material.getPrice()));
        return summary.toString();
    }

    public double getBasePrice(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        Material current = material;
        while (current instanceof MaterialDecorator) {
            current = ((MaterialDecorator)current).getDecoratedMaterial();
        }
        return current.getPrice();
    }

    public boolean hasEnhancements(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        return material instanceof MaterialDecorator;
    }

    public int getEnhancementCount(Material material) {
        if (material == null) {
            return 0;
        }
        int count = 0;
        Material current = material;
        while (current instanceof MaterialDecorator) {
            ++count;
            current = ((MaterialDecorator)current).getDecoratedMaterial();
        }
        return count;
    }

    public Material getBaseMaterial(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        Material current = material;
        while (current instanceof MaterialDecorator) {
            current = ((MaterialDecorator)current).getDecoratedMaterial();
        }
        return current;
    }

    public boolean hasEnhancement(Material material, Class<? extends MaterialDecorator> enhancementType) {
        if (material == null || enhancementType == null) {
            return false;
        }
        Material current = material;
        while (current instanceof MaterialDecorator) {
            if (enhancementType.isInstance(current)) {
                return true;
            }
            current = ((MaterialDecorator)current).getDecoratedMaterial();
        }
        return false;
    }

    public String toString() {
        return "MaterialEnhancementService[Available enhancements: Gift Wrapping, Expedited Delivery, Digital Annotations]";
    }
}

