/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.decorator;

import com.university.bookstore.model.Material;
import java.util.Objects;

public abstract class MaterialDecorator
extends Material {
    protected final Material decoratedMaterial;

    public MaterialDecorator(Material material) {
        super(material.getId(), material.getTitle(), material.getPrice(), material.getYear(), material.getType());
        this.decoratedMaterial = Objects.requireNonNull(material, "Material cannot be null");
    }

    @Override
    public String getCreator() {
        return this.decoratedMaterial.getCreator();
    }

    @Override
    public String getDisplayInfo() {
        return this.decoratedMaterial.getDisplayInfo();
    }

    @Override
    public double getDiscountRate() {
        return this.decoratedMaterial.getDiscountRate();
    }

    public Material getDecoratedMaterial() {
        return this.decoratedMaterial;
    }

    public Material getBaseMaterial() {
        Material current = this.decoratedMaterial;
        while (current instanceof MaterialDecorator) {
            current = ((MaterialDecorator)current).getDecoratedMaterial();
        }
        return current;
    }

    public int getDecoratorCount() {
        int count = 0;
        Material current = this.decoratedMaterial;
        while (current instanceof MaterialDecorator) {
            ++count;
            current = ((MaterialDecorator)current).getDecoratedMaterial();
        }
        return count;
    }

    public boolean hasDecorators() {
        return this.getDecoratorCount() > 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterialDecorator that = (MaterialDecorator)obj;
        return Objects.equals(this.decoratedMaterial, that.decoratedMaterial);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.decoratedMaterial);
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.decoratedMaterial.getTitle());
    }
}

