/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.decorator;

import com.university.bookstore.decorator.MaterialDecorator;
import com.university.bookstore.model.Material;
import java.util.Objects;

public class GiftWrappingDecorator
extends MaterialDecorator {
    private static final double GIFT_WRAPPING_COST = 5.99;
    private final String wrappingStyle;

    public GiftWrappingDecorator(Material material, String wrappingStyle) {
        super(material);
        if (wrappingStyle == null || wrappingStyle.trim().isEmpty()) {
            throw new IllegalArgumentException("Wrapping style cannot be null or empty");
        }
        this.wrappingStyle = wrappingStyle.trim();
    }

    @Override
    public double getPrice() {
        return this.decoratedMaterial.getPrice() + 5.99;
    }

    @Override
    public String getDisplayInfo() {
        return this.decoratedMaterial.getDisplayInfo() + String.format(" [Gift Wrapped: %s (+$%.2f)]", this.wrappingStyle, 5.99);
    }

    public String getWrappingStyle() {
        return this.wrappingStyle;
    }

    public double getGiftWrappingCost() {
        return 5.99;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GiftWrappingDecorator that = (GiftWrappingDecorator)obj;
        return Objects.equals(this.wrappingStyle, that.wrappingStyle);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.wrappingStyle);
    }
}

