/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.decorator;

import com.university.bookstore.decorator.MaterialDecorator;
import com.university.bookstore.model.Material;
import java.util.Objects;

public class ExpeditedDeliveryDecorator
extends MaterialDecorator {
    private static final double EXPEDITED_COST = 12.99;
    private final int deliveryDays;

    public ExpeditedDeliveryDecorator(Material material, int deliveryDays) {
        super(material);
        if (deliveryDays < 1) {
            throw new IllegalArgumentException("Delivery days must be at least 1: " + deliveryDays);
        }
        this.deliveryDays = deliveryDays;
    }

    @Override
    public double getPrice() {
        return this.decoratedMaterial.getPrice() + 12.99;
    }

    @Override
    public String getDisplayInfo() {
        return this.decoratedMaterial.getDisplayInfo() + String.format(" [Expedited Delivery: %d days (+$%.2f)]", this.deliveryDays, 12.99);
    }

    public int getDeliveryDays() {
        return this.deliveryDays;
    }

    public double getExpeditedDeliveryCost() {
        return 12.99;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ExpeditedDeliveryDecorator that = (ExpeditedDeliveryDecorator)obj;
        return this.deliveryDays == that.deliveryDays;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deliveryDays);
    }
}

