/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.decorator;

import com.university.bookstore.decorator.MaterialDecorator;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DigitalAnnotationDecorator
extends MaterialDecorator {
    private static final double ANNOTATION_COST = 2.99;
    private final List<String> annotations = new ArrayList<String>();

    public DigitalAnnotationDecorator(Material material) {
        super(material);
    }

    @Override
    public double getPrice() {
        return this.decoratedMaterial.getPrice() + 2.99;
    }

    @Override
    public String getDisplayInfo() {
        return this.decoratedMaterial.getDisplayInfo() + String.format(" [Digital Annotations: %d notes (+$%.2f)]", this.annotations.size(), 2.99);
    }

    public void addAnnotation(String annotation) {
        if (annotation == null || annotation.trim().isEmpty()) {
            throw new IllegalArgumentException("Annotation cannot be null or empty");
        }
        this.annotations.add(annotation.trim());
    }

    public String removeAnnotation(int index) {
        if (index < 0 || index >= this.annotations.size()) {
            throw new IndexOutOfBoundsException("Invalid annotation index: " + index);
        }
        return this.annotations.remove(index);
    }

    public List<String> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public int getAnnotationCount() {
        return this.annotations.size();
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    public double getDigitalAnnotationCost() {
        return 2.99;
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DigitalAnnotationDecorator that = (DigitalAnnotationDecorator)obj;
        return Objects.equals(this.annotations, that.annotations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.annotations);
    }
}

