/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.controller;

import com.university.bookstore.api.MaterialStore;
import com.university.bookstore.model.Material;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/materials"})
public class MaterialController {
    private final MaterialStore materialStore;

    public MaterialController(MaterialStore materialStore) {
        this.materialStore = materialStore;
    }

    @GetMapping
    public ResponseEntity<List<Material>> getAllMaterials() {
        List<Material> materials = this.materialStore.getAllMaterials();
        return ResponseEntity.ok(materials);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Material> getMaterialById(@PathVariable(value="id") String id) {
        Optional<Material> material = this.materialStore.findById(id);
        return material.map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Material> createMaterial(@RequestBody Material material) {
        try {
            boolean added = this.materialStore.addMaterial(material);
            if (added) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)material);
            }
            return ResponseEntity.badRequest().build();
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Material> updateMaterial(@PathVariable(value="id") String id, @RequestBody Material material) {
        Optional<Material> existing = this.materialStore.removeMaterial(id);
        if (existing.isPresent()) {
            boolean added = this.materialStore.addMaterial(material);
            if (added) {
                return ResponseEntity.ok((Object)material);
            }
            this.materialStore.addMaterial(existing.get());
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteMaterial(@PathVariable(value="id") String id) {
        Optional<Material> removed = this.materialStore.removeMaterial(id);
        return removed.isPresent() ? ResponseEntity.noContent().build() : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/search/title"})
    public ResponseEntity<List<Material>> searchByTitle(@RequestParam(value="q") String q) {
        List<Material> materials = this.materialStore.searchByTitle(q);
        return ResponseEntity.ok(materials);
    }

    @GetMapping(value={"/search/creator"})
    public ResponseEntity<List<Material>> searchByCreator(@RequestParam(value="q") String q) {
        List<Material> materials = this.materialStore.searchByCreator(q);
        return ResponseEntity.ok(materials);
    }

    @GetMapping(value={"/type/{type}"})
    public ResponseEntity<List<Material>> getMaterialsByType(@PathVariable(value="type") Material.MaterialType type) {
        List<Material> materials = this.materialStore.getMaterialsByType(type);
        return ResponseEntity.ok(materials);
    }

    @GetMapping(value={"/recent"})
    public ResponseEntity<List<Material>> getRecentMaterials(@RequestParam(value="years", defaultValue="5") int years) {
        List<Material> materials = this.materialStore.findRecentMaterials(years);
        return ResponseEntity.ok(materials);
    }

    @GetMapping(value={"/price-range"})
    public ResponseEntity<List<Material>> getMaterialsByPriceRange(@RequestParam(value="min") double min, @RequestParam(value="max") double max) {
        List<Material> materials = this.materialStore.getMaterialsByPriceRange(min, max);
        return ResponseEntity.ok(materials);
    }

    @GetMapping(value={"/stats"})
    public ResponseEntity<MaterialStore.InventoryStats> getInventoryStats() {
        MaterialStore.InventoryStats stats = this.materialStore.getInventoryStats();
        return ResponseEntity.ok((Object)stats);
    }

    @GetMapping(value={"/count"})
    public ResponseEntity<Integer> getMaterialCount() {
        int count = this.materialStore.size();
        return ResponseEntity.ok((Object)count);
    }
}

