/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.composite;

import com.university.bookstore.composite.MaterialComponent;
import com.university.bookstore.model.Material;
import java.util.List;
import java.util.Objects;

public class MaterialLeaf
implements MaterialComponent {
    private final Material material;

    public MaterialLeaf(Material material) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
    }

    @Override
    public String getTitle() {
        return this.material.getTitle();
    }

    @Override
    public double getPrice() {
        return this.material.getPrice();
    }

    @Override
    public double getDiscountedPrice() {
        return this.material.getDiscountedPrice();
    }

    @Override
    public String getDescription() {
        return this.material.getDisplayInfo();
    }

    @Override
    public List<Material> getMaterials() {
        return List.of(this.material);
    }

    @Override
    public int getItemCount() {
        return 1;
    }

    @Override
    public double getDiscountRate() {
        return this.material.getDiscountRate();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getId() {
        return this.material.getId();
    }

    public Material.MaterialType getType() {
        return this.material.getType();
    }

    public String getCreator() {
        return this.material.getCreator();
    }

    public int getYear() {
        return this.material.getYear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterialLeaf that = (MaterialLeaf)obj;
        return Objects.equals(this.material, that.material);
    }

    public int hashCode() {
        return Objects.hash(this.material);
    }

    public String toString() {
        return String.format("MaterialLeaf[%s]", this.material.getTitle());
    }
}

