/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.composite;

import com.university.bookstore.composite.MaterialComponent;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MaterialBundle
implements MaterialComponent {
    private final String bundleName;
    private final List<MaterialComponent> components;
    private final double bundleDiscount;

    public MaterialBundle(String bundleName, double bundleDiscount) {
        if (bundleName == null || bundleName.trim().isEmpty()) {
            throw new IllegalArgumentException("Bundle name cannot be null or empty");
        }
        this.bundleName = bundleName.trim();
        this.components = new ArrayList<MaterialComponent>();
        this.bundleDiscount = Math.max(0.0, Math.min(1.0, bundleDiscount));
    }

    public void addComponent(MaterialComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        if (component == this || component instanceof MaterialBundle && this.containsBundle((MaterialBundle)component)) {
            throw new IllegalArgumentException("Cannot add bundle to itself or create circular references");
        }
        this.components.add(component);
    }

    public boolean removeComponent(MaterialComponent component) {
        return this.components.remove(component);
    }

    public List<MaterialComponent> getComponents() {
        return new ArrayList<MaterialComponent>(this.components);
    }

    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public String getTitle() {
        return this.bundleName;
    }

    @Override
    public double getPrice() {
        return this.components.stream().mapToDouble(MaterialComponent::getPrice).sum();
    }

    @Override
    public double getDiscountedPrice() {
        double totalPrice = this.getPrice();
        return totalPrice * (1.0 - this.bundleDiscount);
    }

    @Override
    public String getDescription() {
        StringBuilder desc = new StringBuilder();
        desc.append("Bundle: ").append(this.bundleName).append(" (").append(this.getItemCount()).append(" items, ").append(String.format("%.1f%% discount", this.bundleDiscount * 100.0)).append(")\n");
        for (MaterialComponent component : this.components) {
            desc.append("  - ").append(component.getDescription()).append("\n");
        }
        return desc.toString();
    }

    @Override
    public List<Material> getMaterials() {
        return this.components.stream().flatMap(component -> component.getMaterials().stream()).collect(Collectors.toList());
    }

    @Override
    public int getItemCount() {
        return this.components.stream().mapToInt(MaterialComponent::getItemCount).sum();
    }

    @Override
    public double getDiscountRate() {
        return this.bundleDiscount;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public double getBundleDiscount() {
        return this.bundleDiscount;
    }

    public double getTotalSavings() {
        return this.getPrice() - this.getDiscountedPrice();
    }

    public boolean containsType(Material.MaterialType type) {
        return this.getMaterials().stream().anyMatch(material -> material.getType() == type);
    }

    public List<Material> getMaterialsByType(Material.MaterialType type) {
        return this.getMaterials().stream().filter(material -> material.getType() == type).collect(Collectors.toList());
    }

    public boolean containsMaterial(Material material) {
        return this.getMaterials().contains(material);
    }

    private boolean containsBundle(MaterialBundle bundle) {
        for (MaterialComponent component : this.components) {
            MaterialBundle childBundle;
            if (component == bundle) {
                return true;
            }
            if (!(component instanceof MaterialBundle) || !(childBundle = (MaterialBundle)component).containsBundle(bundle)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterialBundle that = (MaterialBundle)obj;
        return Objects.equals(this.bundleName, that.bundleName) && Double.compare(that.bundleDiscount, this.bundleDiscount) == 0 && Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.bundleName, this.bundleDiscount, this.components);
    }

    public String toString() {
        return String.format("MaterialBundle[%s, %d items, %.1f%% discount, $%.2f]", this.bundleName, this.getItemCount(), this.bundleDiscount * 100.0, this.getDiscountedPrice());
    }
}

